/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.choices;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.transitions.Transition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"path", "value", "operator", "transition"})
public class DefaultChoice
implements Serializable,
Choice {
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="JSON Path that selects the value of the input data to be matched")
    @NotNull
    private String path;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Matching value")
    @NotNull
    private String value;
    @JsonProperty(value="operator")
    @JsonPropertyDescription(value="Specifies how the input data is compared with the values")
    @NotNull
    private Operator operator;
    @JsonProperty(value="transition")
    @Valid
    private Transition transition;
    private static final long serialVersionUID = 119747170163935975L;

    public DefaultChoice() {
    }

    public DefaultChoice(String path, String value, Operator operator) {
        this.path = path;
        this.value = value;
        this.operator = operator;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public DefaultChoice withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public DefaultChoice withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public DefaultChoice withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty(value="transition")
    public Transition getTransition() {
        return this.transition;
    }

    @JsonProperty(value="transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DefaultChoice withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    public static enum Operator {
        EQUALS("Equals"),
        LESS_THAN("LessThan"),
        LESS_THAN_EQUALS("LessThanEquals"),
        GREATER_THAN("GreaterThan"),
        GREATER_THAN_EQUALS("GreaterThanEquals");

        private final String value;
        private static final Map<String, Operator> CONSTANTS;

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

