/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.choices.DefaultChoice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChoiceOperatorDeserializer
extends StdDeserializer<DefaultChoice.Operator> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(DefaultChoiceOperatorDeserializer.class);
    private WorkflowPropertySource context;

    public DefaultChoiceOperatorDeserializer() {
        this(DefaultChoice.Operator.class);
    }

    public DefaultChoiceOperatorDeserializer(WorkflowPropertySource context) {
        this(DefaultChoice.Operator.class);
        this.context = context;
    }

    public DefaultChoiceOperatorDeserializer(Class<?> vc) {
        super(vc);
    }

    public DefaultChoice.Operator deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return DefaultChoice.Operator.fromValue(result);
                }
                return DefaultChoice.Operator.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return DefaultChoice.Operator.fromValue(jp.getText());
            }
        }
        return DefaultChoice.Operator.fromValue(jp.getText());
    }
}

