/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.actions.Action;
import org.jbpm.serverless.workflow.api.filters.EventDataFilter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"eventRefs", "actionMode", "actions", "eventDataFilter"})
public class EventsActions
implements Serializable {
    @JsonProperty(value="eventRefs")
    @JsonPropertyDescription(value="References one or more unique event names in the defined workflow events")
    @Valid
    @NotNull
    private List<String> eventRefs = new ArrayList<String>();
    @JsonProperty(value="actionMode")
    @JsonPropertyDescription(value="Specifies how actions are to be performed (in sequence of parallel)")
    private ActionMode actionMode = ActionMode.fromValue("SEQUENTIAL");
    @JsonProperty(value="actions")
    @JsonPropertyDescription(value="Actions to be performed.")
    @Valid
    @NotNull
    private List<Action> actions = new ArrayList<Action>();
    @JsonProperty(value="eventDataFilter")
    @Valid
    private EventDataFilter eventDataFilter;
    private static final long serialVersionUID = 7026517811213702597L;

    public EventsActions() {
    }

    public EventsActions(List<String> eventRefs, List<Action> actions) {
        this.eventRefs = eventRefs;
        this.actions = actions;
    }

    @JsonProperty(value="eventRefs")
    public List<String> getEventRefs() {
        return this.eventRefs;
    }

    @JsonProperty(value="eventRefs")
    public void setEventRefs(List<String> eventRefs) {
        this.eventRefs = eventRefs;
    }

    public EventsActions withEventRefs(List<String> eventRefs) {
        this.eventRefs = eventRefs;
        return this;
    }

    @JsonProperty(value="actionMode")
    public ActionMode getActionMode() {
        return this.actionMode;
    }

    @JsonProperty(value="actionMode")
    public void setActionMode(ActionMode actionMode) {
        this.actionMode = actionMode;
    }

    public EventsActions withActionMode(ActionMode actionMode) {
        this.actionMode = actionMode;
        return this;
    }

    @JsonProperty(value="actions")
    public List<Action> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public EventsActions withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    @JsonProperty(value="eventDataFilter")
    public EventDataFilter getEventDataFilter() {
        return this.eventDataFilter;
    }

    @JsonProperty(value="eventDataFilter")
    public void setEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
    }

    public EventsActions withEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
        return this;
    }

    public static enum ActionMode {
        SEQUENTIAL("SEQUENTIAL"),
        PARALLEL("PARALLEL");

        private final String value;
        private static final Map<String, ActionMode> CONSTANTS;

        private ActionMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ActionMode fromValue(String value) {
            ActionMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ActionMode>();
            for (ActionMode c : ActionMode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

