/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.mapper;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.choices.DefaultChoice;
import org.jbpm.serverless.workflow.api.deserializers.ChoiceDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.DefaultChoiceOperatorDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.DefaultStateTypeDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.EventsActionsActionModeDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.ExtensionDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.OperationStateActionModeDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.StateDeserializer;
import org.jbpm.serverless.workflow.api.deserializers.StringValueDeserializer;
import org.jbpm.serverless.workflow.api.events.EventsActions;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.interfaces.Extension;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.serializers.CallbackStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.DelayStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.EventStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.ExtensionSerializer;
import org.jbpm.serverless.workflow.api.serializers.ForEachStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.OperationStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.ParallelStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.RelayStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.SubflowStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.SwitchStateSerializer;
import org.jbpm.serverless.workflow.api.serializers.WorkflowSerializer;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.states.OperationState;

public class WorkflowModule
extends SimpleModule {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource workflowPropertySource;
    private ExtensionSerializer extensionSerializer;
    private ExtensionDeserializer extensionDeserializer;

    public WorkflowModule() {
        this(null);
    }

    public WorkflowModule(WorkflowPropertySource workflowPropertySource) {
        super("workflow-module");
        this.workflowPropertySource = workflowPropertySource;
        this.extensionSerializer = new ExtensionSerializer();
        this.extensionDeserializer = new ExtensionDeserializer(workflowPropertySource);
        this.addDefaultSerializers();
        this.addDefaultDeserializers();
    }

    private void addDefaultSerializers() {
        this.addSerializer((JsonSerializer)new WorkflowSerializer());
        this.addSerializer((JsonSerializer)new EventStateSerializer());
        this.addSerializer((JsonSerializer)new DelayStateSerializer());
        this.addSerializer((JsonSerializer)new OperationStateSerializer());
        this.addSerializer((JsonSerializer)new ParallelStateSerializer());
        this.addSerializer((JsonSerializer)new SwitchStateSerializer());
        this.addSerializer((JsonSerializer)new SubflowStateSerializer());
        this.addSerializer((JsonSerializer)new RelayStateSerializer());
        this.addSerializer((JsonSerializer)new ForEachStateSerializer());
        this.addSerializer((JsonSerializer)new CallbackStateSerializer());
        this.addSerializer((JsonSerializer)this.extensionSerializer);
    }

    private void addDefaultDeserializers() {
        this.addDeserializer(State.class, (JsonDeserializer)new StateDeserializer(this.workflowPropertySource));
        this.addDeserializer(Choice.class, (JsonDeserializer)new ChoiceDeserializer());
        this.addDeserializer(String.class, (JsonDeserializer)new StringValueDeserializer(this.workflowPropertySource));
        this.addDeserializer(EventsActions.ActionMode.class, (JsonDeserializer)new EventsActionsActionModeDeserializer(this.workflowPropertySource));
        this.addDeserializer(OperationState.ActionMode.class, (JsonDeserializer)new OperationStateActionModeDeserializer(this.workflowPropertySource));
        this.addDeserializer(DefaultState.Type.class, (JsonDeserializer)new DefaultStateTypeDeserializer(this.workflowPropertySource));
        this.addDeserializer(DefaultChoice.Operator.class, (JsonDeserializer)new DefaultChoiceOperatorDeserializer(this.workflowPropertySource));
        this.addDeserializer(Extension.class, (JsonDeserializer)this.extensionDeserializer);
    }

    public ExtensionSerializer getExtensionSerializer() {
        return this.extensionSerializer;
    }

    public ExtensionDeserializer getExtensionDeserializer() {
        return this.extensionDeserializer;
    }
}

