
package org.jbpm.serverless.workflow.api.end;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.produce.ProduceEvent;


/**
 * State end definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "kind",
    "produceEvent"
})
public class End implements Serializable
{

    /**
     * Kind of End definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @JsonPropertyDescription("Kind of End definition")
    @NotNull
    private End.Kind kind = End.Kind.fromValue("default");
    @JsonProperty("produceEvent")
    @Valid
    private ProduceEvent produceEvent;
    private final static long serialVersionUID = -2678982719114085972L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public End() {
    }

    /**
     * 
     * @param kind
     */
    public End(End.Kind kind) {
        super();
        this.kind = kind;
    }

    /**
     * Kind of End definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public End.Kind getKind() {
        return kind;
    }

    /**
     * Kind of End definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public void setKind(End.Kind kind) {
        this.kind = kind;
    }

    public End withKind(End.Kind kind) {
        this.kind = kind;
        return this;
    }

    @JsonProperty("produceEvent")
    public ProduceEvent getProduceEvent() {
        return produceEvent;
    }

    @JsonProperty("produceEvent")
    public void setProduceEvent(ProduceEvent produceEvent) {
        this.produceEvent = produceEvent;
    }

    public End withProduceEvent(ProduceEvent produceEvent) {
        this.produceEvent = produceEvent;
        return this;
    }

    public enum Kind {

        DEFAULT("default"),
        TERMINATE("terminate"),
        EVENT("event");
        private final String value;
        private final static Map<String, End.Kind> CONSTANTS = new HashMap<String, End.Kind>();

        static {
            for (End.Kind c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Kind(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static End.Kind fromValue(String value) {
            End.Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
