
package org.jbpm.serverless.workflow.api.filters;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataOutputPath"
})
public class ErrorDataFilter implements Serializable
{

    /**
     * JSONPath definition that selects parts of the error data, to be merged with the states data
     * 
     */
    @JsonProperty("dataOutputPath")
    @JsonPropertyDescription("JSONPath definition that selects parts of the error data, to be merged with the states data")
    private String dataOutputPath;
    private final static long serialVersionUID = -5484933330055838571L;

    /**
     * JSONPath definition that selects parts of the error data, to be merged with the states data
     * 
     */
    @JsonProperty("dataOutputPath")
    public String getDataOutputPath() {
        return dataOutputPath;
    }

    /**
     * JSONPath definition that selects parts of the error data, to be merged with the states data
     * 
     */
    @JsonProperty("dataOutputPath")
    public void setDataOutputPath(String dataOutputPath) {
        this.dataOutputPath = dataOutputPath;
    }

    public ErrorDataFilter withDataOutputPath(String dataOutputPath) {
        this.dataOutputPath = dataOutputPath;
        return this;
    }

}
