
package org.jbpm.serverless.workflow.api.schedule;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Start state schedule definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "interval"
})
public class Schedule implements Serializable
{

    /**
     * Time interval describing when the workflow starting state is active
     * (Required)
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("Time interval describing when the workflow starting state is active")
    @NotNull
    private String interval;
    private final static long serialVersionUID = -7278581556770589747L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Schedule() {
    }

    /**
     * 
     * @param interval
     */
    public Schedule(String interval) {
        super();
        this.interval = interval;
    }

    /**
     * Time interval describing when the workflow starting state is active
     * (Required)
     * 
     */
    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    /**
     * Time interval describing when the workflow starting state is active
     * (Required)
     * 
     */
    @JsonProperty("interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Schedule withInterval(String interval) {
        this.interval = interval;
        return this;
    }

}
