
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Set up and inject the state's data input to data output. Does not perform any actions
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data"
})
public class InjectState
    extends DefaultState
    implements Serializable, State
{

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("JSON object which can be set as states data input and can be manipulated via filters")
    @Valid
    private JsonNode data;
    private final static long serialVersionUID = -2010688725181049783L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public InjectState() {
    }

    /**
     * 
     * @param name
     * @param type
     */
    public InjectState(java.lang.String name, DefaultState.Type type) {
        super(name, type);
    }

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * 
     */
    @JsonProperty("data")
    public JsonNode getData() {
        return data;
    }

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * 
     */
    @JsonProperty("data")
    public void setData(JsonNode data) {
        this.data = data;
    }

    public InjectState withData(JsonNode data) {
        this.data = data;
        return this;
    }

    @Override
    public InjectState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public InjectState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public InjectState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public InjectState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public InjectState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public InjectState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public InjectState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public InjectState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public InjectState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public InjectState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public InjectState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public InjectState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
