/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.states.OperationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationStateActionModeDeserializer
extends StdDeserializer<OperationState.ActionMode> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(OperationStateActionModeDeserializer.class);
    private WorkflowPropertySource context;

    public OperationStateActionModeDeserializer() {
        this(OperationState.ActionMode.class);
    }

    public OperationStateActionModeDeserializer(WorkflowPropertySource context) {
        this(OperationState.ActionMode.class);
        this.context = context;
    }

    public OperationStateActionModeDeserializer(Class<?> vc) {
        super(vc);
    }

    public OperationState.ActionMode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return OperationState.ActionMode.fromValue(result);
                }
                return OperationState.ActionMode.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return OperationState.ActionMode.fromValue(jp.getText());
            }
        }
        return OperationState.ActionMode.fromValue(jp.getText());
    }
}

