
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Default State
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "name",
    "type",
    "start",
    "end",
    "stateDataFilter",
    "metadata",
    "transition",
    "dataInputSchema",
    "dataOutputSchema",
    "onError",
    "retry"
})
public class DefaultState implements Serializable, State
{

    /**
     * State unique identifier
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("State unique identifier")
    @Size(min = 1)
    private java.lang.String id;
    /**
     * Unique name of the state
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Unique name of the state")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * State type
     * (Required)
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("State type")
    @NotNull
    private DefaultState.Type type;
    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    @JsonPropertyDescription("State start definition")
    @Valid
    private Start start;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    @JsonProperty("stateDataFilter")
    @Valid
    private StateDataFilter stateDataFilter;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    @JsonProperty("transition")
    @Valid
    private Transition transition;
    /**
     * URI to JSON Schema that state data input adheres to
     * 
     */
    @JsonProperty("dataInputSchema")
    @JsonPropertyDescription("URI to JSON Schema that state data input adheres to")
    private java.lang.String dataInputSchema;
    /**
     * URI to JSON Schema that state data output adheres to
     * 
     */
    @JsonProperty("dataOutputSchema")
    @JsonPropertyDescription("URI to JSON Schema that state data output adheres to")
    private java.lang.String dataOutputSchema;
    /**
     * State onError definition
     * 
     */
    @JsonProperty("onError")
    @JsonPropertyDescription("State onError definition")
    @Valid
    private List<Error> onError = new ArrayList<Error>();
    /**
     * State retry definition
     * 
     */
    @JsonProperty("retry")
    @JsonPropertyDescription("State retry definition")
    @Valid
    private List<Retry> retry = new ArrayList<Retry>();
    private final static long serialVersionUID = 3076020899083504720L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DefaultState() {
    }

    /**
     * 
     * @param name
     * @param type
     */
    public DefaultState(java.lang.String name, DefaultState.Type type) {
        super();
        this.name = name;
        this.type = type;
    }

    /**
     * State unique identifier
     * 
     */
    @JsonProperty("id")
    public java.lang.String getId() {
        return id;
    }

    /**
     * State unique identifier
     * 
     */
    @JsonProperty("id")
    public void setId(java.lang.String id) {
        this.id = id;
    }

    public DefaultState withId(java.lang.String id) {
        this.id = id;
        return this;
    }

    /**
     * Unique name of the state
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Unique name of the state
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public DefaultState withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * State type
     * (Required)
     * 
     */
    @JsonProperty("type")
    public DefaultState.Type getType() {
        return type;
    }

    /**
     * State type
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(DefaultState.Type type) {
        this.type = type;
    }

    public DefaultState withType(DefaultState.Type type) {
        this.type = type;
        return this;
    }

    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    public Start getStart() {
        return start;
    }

    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    public void setStart(Start start) {
        this.start = start;
    }

    public DefaultState withStart(Start start) {
        this.start = start;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public DefaultState withEnd(End end) {
        this.end = end;
        return this;
    }

    @JsonProperty("stateDataFilter")
    public StateDataFilter getStateDataFilter() {
        return stateDataFilter;
    }

    @JsonProperty("stateDataFilter")
    public void setStateDataFilter(StateDataFilter stateDataFilter) {
        this.stateDataFilter = stateDataFilter;
    }

    public DefaultState withStateDataFilter(StateDataFilter stateDataFilter) {
        this.stateDataFilter = stateDataFilter;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public DefaultState withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DefaultState withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * URI to JSON Schema that state data input adheres to
     * 
     */
    @JsonProperty("dataInputSchema")
    public java.lang.String getDataInputSchema() {
        return dataInputSchema;
    }

    /**
     * URI to JSON Schema that state data input adheres to
     * 
     */
    @JsonProperty("dataInputSchema")
    public void setDataInputSchema(java.lang.String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
    }

    public DefaultState withDataInputSchema(java.lang.String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
        return this;
    }

    /**
     * URI to JSON Schema that state data output adheres to
     * 
     */
    @JsonProperty("dataOutputSchema")
    public java.lang.String getDataOutputSchema() {
        return dataOutputSchema;
    }

    /**
     * URI to JSON Schema that state data output adheres to
     * 
     */
    @JsonProperty("dataOutputSchema")
    public void setDataOutputSchema(java.lang.String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
    }

    public DefaultState withDataOutputSchema(java.lang.String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
        return this;
    }

    /**
     * State onError definition
     * 
     */
    @JsonProperty("onError")
    public List<Error> getOnError() {
        return onError;
    }

    /**
     * State onError definition
     * 
     */
    @JsonProperty("onError")
    public void setOnError(List<Error> onError) {
        this.onError = onError;
    }

    public DefaultState withOnError(List<Error> onError) {
        this.onError = onError;
        return this;
    }

    /**
     * State retry definition
     * 
     */
    @JsonProperty("retry")
    public List<Retry> getRetry() {
        return retry;
    }

    /**
     * State retry definition
     * 
     */
    @JsonProperty("retry")
    public void setRetry(List<Retry> retry) {
        this.retry = retry;
    }

    public DefaultState withRetry(List<Retry> retry) {
        this.retry = retry;
        return this;
    }

    public enum Type {

        EVENT("event"),
        OPERATION("operation"),
        SWITCH("switch"),
        DELAY("delay"),
        PARALLEL("parallel"),
        SUBFLOW("subflow"),
        INJECT("inject"),
        FOREACH("foreach"),
        CALLBACK("callback");
        private final java.lang.String value;
        private final static Map<java.lang.String, DefaultState.Type> CONSTANTS = new HashMap<java.lang.String, DefaultState.Type>();

        static {
            for (DefaultState.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static DefaultState.Type fromValue(java.lang.String value) {
            DefaultState.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
