/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.events.EventsActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsActionsActionModeDeserializer
extends StdDeserializer<EventsActions.ActionMode> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(EventsActionsActionModeDeserializer.class);
    private WorkflowPropertySource context;

    public EventsActionsActionModeDeserializer() {
        this(EventsActions.ActionMode.class);
    }

    public EventsActionsActionModeDeserializer(WorkflowPropertySource context) {
        this(EventsActions.ActionMode.class);
        this.context = context;
    }

    public EventsActionsActionModeDeserializer(Class<?> vc) {
        super(vc);
    }

    public EventsActions.ActionMode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return EventsActions.ActionMode.fromValue(result);
                }
                return EventsActions.ActionMode.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return EventsActions.ActionMode.fromValue(jp.getText());
            }
        }
        return EventsActions.ActionMode.fromValue(jp.getText());
    }
}

