
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.events.EventsActions;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * This state is used to wait for events from event sources and then to invoke one or more functions to run in sequence or in parallel.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "exclusive",
    "eventsActions",
    "timeout"
})
public class EventState
    extends DefaultState
    implements Serializable, State
{

    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     * 
     */
    @JsonProperty("exclusive")
    @JsonPropertyDescription("If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed")
    private boolean exclusive = true;
    /**
     * Define what events trigger one or more actions to be performed
     * (Required)
     * 
     */
    @JsonProperty("eventsActions")
    @JsonPropertyDescription("Define what events trigger one or more actions to be performed")
    @Valid
    @NotNull
    private List<EventsActions> eventsActions = new ArrayList<EventsActions>();
    /**
     * Time period to wait for incoming events (ISO 8601 format)
     * 
     */
    @JsonProperty("timeout")
    @JsonPropertyDescription("Time period to wait for incoming events (ISO 8601 format)")
    private java.lang.String timeout;
    private final static long serialVersionUID = -8152205520756253422L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventState() {
    }

    /**
     * 
     * @param name
     * @param eventsActions
     * @param type
     */
    public EventState(List<EventsActions> eventsActions, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.eventsActions = eventsActions;
    }

    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     * 
     */
    @JsonProperty("exclusive")
    public boolean isExclusive() {
        return exclusive;
    }

    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     * 
     */
    @JsonProperty("exclusive")
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public EventState withExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    /**
     * Define what events trigger one or more actions to be performed
     * (Required)
     * 
     */
    @JsonProperty("eventsActions")
    public List<EventsActions> getEventsActions() {
        return eventsActions;
    }

    /**
     * Define what events trigger one or more actions to be performed
     * (Required)
     * 
     */
    @JsonProperty("eventsActions")
    public void setEventsActions(List<EventsActions> eventsActions) {
        this.eventsActions = eventsActions;
    }

    public EventState withEventsActions(List<EventsActions> eventsActions) {
        this.eventsActions = eventsActions;
        return this;
    }

    /**
     * Time period to wait for incoming events (ISO 8601 format)
     * 
     */
    @JsonProperty("timeout")
    public java.lang.String getTimeout() {
        return timeout;
    }

    /**
     * Time period to wait for incoming events (ISO 8601 format)
     * 
     */
    @JsonProperty("timeout")
    public void setTimeout(java.lang.String timeout) {
        this.timeout = timeout;
    }

    public EventState withTimeout(java.lang.String timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public EventState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public EventState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public EventState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public EventState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public EventState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public EventState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public EventState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public EventState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public EventState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public EventState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public EventState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public EventState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
