
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.branches.Branch;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Consists of a number of states that are executed in parallel
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "branches"
})
public class ParallelState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    @JsonPropertyDescription("Branch Definitions")
    @Valid
    @NotNull
    private List<Branch> branches = new ArrayList<Branch>();
    private final static long serialVersionUID = 3227423030833024419L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParallelState() {
    }

    /**
     * 
     * @param name
     * @param branches
     * @param type
     */
    public ParallelState(List<Branch> branches, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.branches = branches;
    }

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    public List<Branch> getBranches() {
        return branches;
    }

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public ParallelState withBranches(List<Branch> branches) {
        this.branches = branches;
        return this;
    }

    @Override
    public ParallelState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ParallelState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ParallelState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ParallelState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public ParallelState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ParallelState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ParallelState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ParallelState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ParallelState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public ParallelState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public ParallelState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public ParallelState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
