
package org.jbpm.serverless.workflow.api.branches;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.interfaces.State;


/**
 * Branch Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "states",
    "waitForCompletion"
})
public class Branch implements Serializable
{

    /**
     * Branch name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Branch name")
    @NotNull
    private String name;
    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    @JsonPropertyDescription("State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    /**
     * Flow must wait for this branch to finish before continuing
     * (Required)
     * 
     */
    @JsonProperty("waitForCompletion")
    @JsonPropertyDescription("Flow must wait for this branch to finish before continuing")
    @NotNull
    private boolean waitForCompletion = false;
    private final static long serialVersionUID = 8149552033065330352L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Branch() {
    }

    /**
     * 
     * @param name
     * @param waitForCompletion
     * @param states
     */
    public Branch(String name, List<State> states, boolean waitForCompletion) {
        super();
        this.name = name;
        this.states = states;
        this.waitForCompletion = waitForCompletion;
    }

    /**
     * Branch name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Branch name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Branch withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public List<State> getStates() {
        return states;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Branch withStates(List<State> states) {
        this.states = states;
        return this;
    }

    /**
     * Flow must wait for this branch to finish before continuing
     * (Required)
     * 
     */
    @JsonProperty("waitForCompletion")
    public boolean isWaitForCompletion() {
        return waitForCompletion;
    }

    /**
     * Flow must wait for this branch to finish before continuing
     * (Required)
     * 
     */
    @JsonProperty("waitForCompletion")
    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public Branch withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

}
