
package org.jbpm.serverless.workflow.api.functions;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "resource",
    "type",
    "metadata"
})
public class Function implements Serializable
{

    /**
     * Function unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Function unique name")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * Function resource (URI)
     * (Required)
     * 
     */
    @JsonProperty("resource")
    @JsonPropertyDescription("Function resource (URI)")
    @NotNull
    private java.lang.String resource;
    /**
     * Type of function to implement. Can be defined by implementations
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("Type of function to implement. Can be defined by implementations")
    @Size(min = 1)
    private java.lang.String type;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    private final static long serialVersionUID = 6388657355228076821L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Function() {
    }

    /**
     * 
     * @param resource
     * @param name
     */
    public Function(java.lang.String name, java.lang.String resource) {
        super();
        this.name = name;
        this.resource = resource;
    }

    /**
     * Function unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Function unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public Function withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Function resource (URI)
     * (Required)
     * 
     */
    @JsonProperty("resource")
    public java.lang.String getResource() {
        return resource;
    }

    /**
     * Function resource (URI)
     * (Required)
     * 
     */
    @JsonProperty("resource")
    public void setResource(java.lang.String resource) {
        this.resource = resource;
    }

    public Function withResource(java.lang.String resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Type of function to implement. Can be defined by implementations
     * 
     */
    @JsonProperty("type")
    public java.lang.String getType() {
        return type;
    }

    /**
     * Type of function to implement. Can be defined by implementations
     * 
     */
    @JsonProperty("type")
    public void setType(java.lang.String type) {
        this.type = type;
    }

    public Function withType(java.lang.String type) {
        this.type = type;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Function withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

}
