/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.actions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.filters.ActionDataFilter;
import org.jbpm.serverless.workflow.api.functions.FunctionRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "functionRef", "timeout", "actionDataFilter"})
public class Action
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Unique action definition name")
    private String name;
    @JsonProperty(value="functionRef")
    @Valid
    @NotNull
    private FunctionRef functionRef;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Time period to wait for function execution to complete")
    private String timeout;
    @JsonProperty(value="actionDataFilter")
    @Valid
    private ActionDataFilter actionDataFilter;
    private static final long serialVersionUID = 5057761710133133581L;

    public Action() {
    }

    public Action(FunctionRef functionRef) {
        this.functionRef = functionRef;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Action withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="functionRef")
    public FunctionRef getFunctionRef() {
        return this.functionRef;
    }

    @JsonProperty(value="functionRef")
    public void setFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
    }

    public Action withFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
        return this;
    }

    @JsonProperty(value="timeout")
    public String getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public Action withTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty(value="actionDataFilter")
    public ActionDataFilter getActionDataFilter() {
        return this.actionDataFilter;
    }

    @JsonProperty(value="actionDataFilter")
    public void setActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
    }

    public Action withActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
        return this;
    }
}

