
package org.jbpm.serverless.workflow.api.events;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "source",
    "type",
    "correlationToken",
    "metadata"
})
public class EventDefinition implements Serializable
{

    /**
     * Event Definition unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Event Definition unique name")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * CloudEvent source UUID
     * (Required)
     * 
     */
    @JsonProperty("source")
    @JsonPropertyDescription("CloudEvent source UUID")
    @NotNull
    private java.lang.String source;
    /**
     * CloudEvent type
     * (Required)
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("CloudEvent type")
    @NotNull
    private java.lang.String type;
    /**
     * Context attribute name of the CloudEvent which value is to be used for event correlation
     * 
     */
    @JsonProperty("correlationToken")
    @JsonPropertyDescription("Context attribute name of the CloudEvent which value is to be used for event correlation")
    private java.lang.String correlationToken;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    private final static long serialVersionUID = 4879490005212697914L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventDefinition() {
    }

    /**
     * 
     * @param name
     * @param source
     * @param type
     */
    public EventDefinition(java.lang.String name, java.lang.String source, java.lang.String type) {
        super();
        this.name = name;
        this.source = source;
        this.type = type;
    }

    /**
     * Event Definition unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Event Definition unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public EventDefinition withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * CloudEvent source UUID
     * (Required)
     * 
     */
    @JsonProperty("source")
    public java.lang.String getSource() {
        return source;
    }

    /**
     * CloudEvent source UUID
     * (Required)
     * 
     */
    @JsonProperty("source")
    public void setSource(java.lang.String source) {
        this.source = source;
    }

    public EventDefinition withSource(java.lang.String source) {
        this.source = source;
        return this;
    }

    /**
     * CloudEvent type
     * (Required)
     * 
     */
    @JsonProperty("type")
    public java.lang.String getType() {
        return type;
    }

    /**
     * CloudEvent type
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(java.lang.String type) {
        this.type = type;
    }

    public EventDefinition withType(java.lang.String type) {
        this.type = type;
        return this;
    }

    /**
     * Context attribute name of the CloudEvent which value is to be used for event correlation
     * 
     */
    @JsonProperty("correlationToken")
    public java.lang.String getCorrelationToken() {
        return correlationToken;
    }

    /**
     * Context attribute name of the CloudEvent which value is to be used for event correlation
     * 
     */
    @JsonProperty("correlationToken")
    public void setCorrelationToken(java.lang.String correlationToken) {
        this.correlationToken = correlationToken;
    }

    public EventDefinition withCorrelationToken(java.lang.String correlationToken) {
        this.correlationToken = correlationToken;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public EventDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

}
