/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.serverless.workflow.api.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEvaluatorProvider {
    private Map<String, ExpressionEvaluator> expressionEvaluatorMap = new HashMap<String, ExpressionEvaluator>();
    private static Logger logger = LoggerFactory.getLogger(ExpressionEvaluatorProvider.class);

    public ExpressionEvaluatorProvider() {
        ServiceLoader<ExpressionEvaluator> foundExpressionEvaluators = ServiceLoader.load(ExpressionEvaluator.class);
        foundExpressionEvaluators.forEach(expressionEvaluator -> {
            this.expressionEvaluatorMap.put(expressionEvaluator.getName(), (ExpressionEvaluator)expressionEvaluator);
            logger.info("Found expression evaluator with name: " + expressionEvaluator.getName());
        });
    }

    public static ExpressionEvaluatorProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public Map<String, ExpressionEvaluator> get() {
        return this.expressionEvaluatorMap;
    }

    private static class LazyHolder {
        static final ExpressionEvaluatorProvider INSTANCE = new ExpressionEvaluatorProvider();

        private LazyHolder() {
        }
    }
}

