
package org.jbpm.serverless.workflow.api.choices;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Single Choice
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "transition"
})
public class SingleChoice
    extends DefaultChoice
    implements Serializable, Choice
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    private final static long serialVersionUID = 8599596003436248048L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SingleChoice() {
    }

    /**
     * 
     * @param transition
     */
    public SingleChoice(Transition transition) {
        super();
        this.transition = transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public SingleChoice withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    @Override
    public SingleChoice withPath(String path) {
        super.withPath(path);
        return this;
    }

    @Override
    public SingleChoice withValue(String value) {
        super.withValue(value);
        return this;
    }

    @Override
    public SingleChoice withOperator(org.jbpm.serverless.workflow.api.choices.DefaultChoice.Operator operator) {
        super.withOperator(operator);
        return this;
    }

}
