
package org.jbpm.serverless.workflow.api.expression;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "language",
    "body"
})
public class Expression implements Serializable
{

    /**
     * Expression language. For example 'spel', 'jexl', 'cel', etc
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("Expression language. For example 'spel', 'jexl', 'cel', etc")
    @Size(min = 1)
    private String language;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("body")
    @NotNull
    private String body;
    private final static long serialVersionUID = -923615158224028628L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Expression() {
    }

    /**
     * 
     * @param body
     */
    public Expression(String body) {
        super();
        this.body = body;
    }

    /**
     * Expression language. For example 'spel', 'jexl', 'cel', etc
     * 
     */
    @JsonProperty("language")
    public String getLanguage() {
        return language;
    }

    /**
     * Expression language. For example 'spel', 'jexl', 'cel', etc
     * 
     */
    @JsonProperty("language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public Expression withLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("body")
    public void setBody(String body) {
        this.body = body;
    }

    public Expression withBody(String body) {
        this.body = body;
        return this;
    }

}
