
package org.jbpm.serverless.workflow.api.choices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Or Choice
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "or",
    "transition"
})
public class OrChoice implements Serializable, Choice
{

    /**
     * List of choices
     * (Required)
     * 
     */
    @JsonProperty("or")
    @JsonPropertyDescription("List of choices")
    @Valid
    @NotNull
    private List<DefaultChoice> or = new ArrayList<DefaultChoice>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    private final static long serialVersionUID = 7737641169989608516L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrChoice() {
    }

    /**
     * 
     * @param or
     * @param transition
     */
    public OrChoice(List<DefaultChoice> or, Transition transition) {
        super();
        this.or = or;
        this.transition = transition;
    }

    /**
     * List of choices
     * (Required)
     * 
     */
    @JsonProperty("or")
    public List<DefaultChoice> getOr() {
        return or;
    }

    /**
     * List of choices
     * (Required)
     * 
     */
    @JsonProperty("or")
    public void setOr(List<DefaultChoice> or) {
        this.or = or;
    }

    public OrChoice withOr(List<DefaultChoice> or) {
        this.or = or;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public OrChoice withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

}
