
package org.jbpm.serverless.workflow.api.start;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.schedule.Schedule;


/**
 * State start definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "kind",
    "schedule"
})
public class Start implements Serializable
{

    /**
     * Kind of Start definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @JsonPropertyDescription("Kind of Start definition")
    @NotNull
    private Start.Kind kind = Start.Kind.fromValue("DEFAULT");
    /**
     * Start state schedule definition
     * 
     */
    @JsonProperty("schedule")
    @JsonPropertyDescription("Start state schedule definition")
    @Valid
    private Schedule schedule;
    private final static long serialVersionUID = 305549881749015101L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Start() {
    }

    /**
     * 
     * @param kind
     */
    public Start(Start.Kind kind) {
        super();
        this.kind = kind;
    }

    /**
     * Kind of Start definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public Start.Kind getKind() {
        return kind;
    }

    /**
     * Kind of Start definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public void setKind(Start.Kind kind) {
        this.kind = kind;
    }

    public Start withKind(Start.Kind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Start state schedule definition
     * 
     */
    @JsonProperty("schedule")
    public Schedule getSchedule() {
        return schedule;
    }

    /**
     * Start state schedule definition
     * 
     */
    @JsonProperty("schedule")
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Start withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public enum Kind {

        DEFAULT("DEFAULT"),
        SCHEDULED("SCHEDULED");
        private final String value;
        private final static Map<String, Start.Kind> CONSTANTS = new HashMap<String, Start.Kind>();

        static {
            for (Start.Kind c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Kind(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Start.Kind fromValue(String value) {
            Start.Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
