/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.states.CallbackState;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.states.DelayState;
import org.jbpm.serverless.workflow.api.states.EventState;
import org.jbpm.serverless.workflow.api.states.ForEachState;
import org.jbpm.serverless.workflow.api.states.OperationState;
import org.jbpm.serverless.workflow.api.states.ParallelState;
import org.jbpm.serverless.workflow.api.states.RelayState;
import org.jbpm.serverless.workflow.api.states.SubflowState;
import org.jbpm.serverless.workflow.api.states.SwitchState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateDeserializer
extends StdDeserializer<State> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(StateDeserializer.class);
    private WorkflowPropertySource context;

    public StateDeserializer() {
        this(State.class);
    }

    public StateDeserializer(Class<?> vc) {
        super(vc);
    }

    public StateDeserializer(WorkflowPropertySource context) {
        this(State.class);
        this.context = context;
    }

    public State deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String typeValue = node.get("type").asText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(typeValue);
                if (result != null) {
                    typeValue = result;
                }
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
            }
        }
        DefaultState.Type type = DefaultState.Type.fromValue(typeValue);
        switch (type) {
            case EVENT: {
                return (State)mapper.treeToValue((TreeNode)node, EventState.class);
            }
            case OPERATION: {
                return (State)mapper.treeToValue((TreeNode)node, OperationState.class);
            }
            case SWITCH: {
                return (State)mapper.treeToValue((TreeNode)node, SwitchState.class);
            }
            case DELAY: {
                return (State)mapper.treeToValue((TreeNode)node, DelayState.class);
            }
            case PARALLEL: {
                return (State)mapper.treeToValue((TreeNode)node, ParallelState.class);
            }
            case SUBFLOW: {
                return (State)mapper.treeToValue((TreeNode)node, SubflowState.class);
            }
            case RELAY: {
                return (State)mapper.treeToValue((TreeNode)node, RelayState.class);
            }
            case FOREACH: {
                return (State)mapper.treeToValue((TreeNode)node, ForEachState.class);
            }
            case CALLBACK: {
                return (State)mapper.treeToValue((TreeNode)node, CallbackState.class);
            }
        }
        return (State)mapper.treeToValue((TreeNode)node, DefaultState.class);
    }
}

