/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.functions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "resource", "type", "metadata"})
public class Function
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Function unique name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="resource")
    @JsonPropertyDescription(value="Function resource (URI)")
    @NotNull
    private String resource;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of function to implement. Can be defined by implementations")
    @Size(min=1)
    private @Size(min=1) String type;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = 6388657355228076821L;

    public Function() {
    }

    public Function(String name, String resource) {
        this.name = name;
        this.resource = resource;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Function withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="resource")
    public String getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    public void setResource(String resource) {
        this.resource = resource;
    }

    public Function withResource(String resource) {
        this.resource = resource;
        return this;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public Function withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Function withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

