/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.retry;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.expression.Expression;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"expression", "interval", "multiplier", "maxAttempts"})
public class Retry
implements Serializable {
    @JsonProperty(value="expression")
    @Valid
    @NotNull
    private Expression expression;
    @JsonProperty(value="interval")
    @JsonPropertyDescription(value="Specifies the amount of time between retries (ISO 8601 format)")
    private String interval;
    @JsonProperty(value="multiplier")
    @JsonPropertyDescription(value="Multiplier value by which interval increases during each attempt (ISO 8601 time format)")
    private String multiplier;
    @JsonProperty(value="maxAttempts")
    @JsonPropertyDescription(value="Maximum number of retry attempts (1 by default). Value of 0 means no retries are performed")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") int maxAttempts = 0;
    private static final long serialVersionUID = -2255817227153669082L;

    public Retry() {
    }

    public Retry(Expression expression) {
        this.expression = expression;
    }

    @JsonProperty(value="expression")
    public Expression getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Retry withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Retry withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    @JsonProperty(value="multiplier")
    public String getMultiplier() {
        return this.multiplier;
    }

    @JsonProperty(value="multiplier")
    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public Retry withMultiplier(String multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @JsonProperty(value="maxAttempts")
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @JsonProperty(value="maxAttempts")
    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Retry withMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }
}

