/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.start;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.schedule.Schedule;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kind", "schedule"})
public class Start
implements Serializable {
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Kind of Start definition")
    @NotNull
    private Kind kind = Kind.fromValue("DEFAULT");
    @JsonProperty(value="schedule")
    @JsonPropertyDescription(value="Start state schedule definition")
    @Valid
    private Schedule schedule;
    private static final long serialVersionUID = 305549881749015101L;

    public Start() {
    }

    public Start(Kind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Start withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    @JsonProperty(value="schedule")
    public Schedule getSchedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Start withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public static enum Kind {
        DEFAULT("DEFAULT"),
        SCHEDULED("SCHEDULED");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

