
package org.jbpm.serverless.workflow.api.error;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.filters.ErrorDataFilter;
import org.jbpm.serverless.workflow.api.transitions.Transition;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "expression",
    "errorDataFilter",
    "transition"
})
public class Error implements Serializable
{

    /**
     * Common Expression Language (CEL) expression. Should be evaluated against error data. Must evaluate to true.
     * (Required)
     * 
     */
    @JsonProperty("expression")
    @JsonPropertyDescription("Common Expression Language (CEL) expression. Should be evaluated against error data. Must evaluate to true.")
    @NotNull
    private String expression;
    @JsonProperty("errorDataFilter")
    @Valid
    private ErrorDataFilter errorDataFilter;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    private final static long serialVersionUID = 8077711631340436355L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Error() {
    }

    /**
     * 
     * @param expression
     * @param transition
     */
    public Error(String expression, Transition transition) {
        super();
        this.expression = expression;
        this.transition = transition;
    }

    /**
     * Common Expression Language (CEL) expression. Should be evaluated against error data. Must evaluate to true.
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public String getExpression() {
        return expression;
    }

    /**
     * Common Expression Language (CEL) expression. Should be evaluated against error data. Must evaluate to true.
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Error withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty("errorDataFilter")
    public ErrorDataFilter getErrorDataFilter() {
        return errorDataFilter;
    }

    @JsonProperty("errorDataFilter")
    public void setErrorDataFilter(ErrorDataFilter errorDataFilter) {
        this.errorDataFilter = errorDataFilter;
    }

    public Error withErrorDataFilter(ErrorDataFilter errorDataFilter) {
        this.errorDataFilter = errorDataFilter;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Error withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

}
