
package org.jbpm.serverless.workflow.api.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.correlation.CorrelationDef;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "source",
    "type",
    "correlation",
    "kind",
    "metadata"
})
public class EventDefinition implements Serializable
{

    /**
     * Event Definition unique name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Event Definition unique name")
    @Size(min = 1)
    private java.lang.String name;
    /**
     * CloudEvent source UUID
     * 
     */
    @JsonProperty("source")
    @JsonPropertyDescription("CloudEvent source UUID")
    private java.lang.String source;
    /**
     * CloudEvent type
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("CloudEvent type")
    private java.lang.String type;
    /**
     * CloudEvent correlation definitions
     * 
     */
    @JsonProperty("correlation")
    @JsonPropertyDescription("CloudEvent correlation definitions")
    @Size(min = 1)
    @Valid
    private List<CorrelationDef> correlation = new ArrayList<CorrelationDef>();
    /**
     * Defines the events as either being consumed or produced by the workflow. Default is consumed
     * 
     */
    @JsonProperty("kind")
    @JsonPropertyDescription("Defines the events as either being consumed or produced by the workflow. Default is consumed")
    private EventDefinition.Kind kind = EventDefinition.Kind.fromValue("consumed");
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    private final static long serialVersionUID = 6604552584694610768L;

    /**
     * Event Definition unique name
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Event Definition unique name
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public EventDefinition withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * CloudEvent source UUID
     * 
     */
    @JsonProperty("source")
    public java.lang.String getSource() {
        return source;
    }

    /**
     * CloudEvent source UUID
     * 
     */
    @JsonProperty("source")
    public void setSource(java.lang.String source) {
        this.source = source;
    }

    public EventDefinition withSource(java.lang.String source) {
        this.source = source;
        return this;
    }

    /**
     * CloudEvent type
     * 
     */
    @JsonProperty("type")
    public java.lang.String getType() {
        return type;
    }

    /**
     * CloudEvent type
     * 
     */
    @JsonProperty("type")
    public void setType(java.lang.String type) {
        this.type = type;
    }

    public EventDefinition withType(java.lang.String type) {
        this.type = type;
        return this;
    }

    /**
     * CloudEvent correlation definitions
     * 
     */
    @JsonProperty("correlation")
    public List<CorrelationDef> getCorrelation() {
        return correlation;
    }

    /**
     * CloudEvent correlation definitions
     * 
     */
    @JsonProperty("correlation")
    public void setCorrelation(List<CorrelationDef> correlation) {
        this.correlation = correlation;
    }

    public EventDefinition withCorrelation(List<CorrelationDef> correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Defines the events as either being consumed or produced by the workflow. Default is consumed
     * 
     */
    @JsonProperty("kind")
    public EventDefinition.Kind getKind() {
        return kind;
    }

    /**
     * Defines the events as either being consumed or produced by the workflow. Default is consumed
     * 
     */
    @JsonProperty("kind")
    public void setKind(EventDefinition.Kind kind) {
        this.kind = kind;
    }

    public EventDefinition withKind(EventDefinition.Kind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public EventDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public enum Kind {

        CONSUMED("consumed"),
        PRODUCED("produced");
        private final java.lang.String value;
        private final static Map<java.lang.String, EventDefinition.Kind> CONSTANTS = new HashMap<java.lang.String, EventDefinition.Kind>();

        static {
            for (EventDefinition.Kind c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Kind(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static EventDefinition.Kind fromValue(java.lang.String value) {
            EventDefinition.Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
