
package org.jbpm.serverless.workflow.api.switchconditions;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.interfaces.SwitchCondition;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Switch state data based condition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "condition",
    "transition",
    "end"
})
public class DataCondition implements Serializable, SwitchCondition
{

    /**
     * JsonPath expression evaluated against state data. True if results are not empty
     * 
     */
    @JsonProperty("condition")
    @JsonPropertyDescription("JsonPath expression evaluated against state data. True if results are not empty")
    private String condition;
    @JsonProperty("transition")
    @Valid
    private Transition transition;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    private final static long serialVersionUID = -8356117201656340937L;

    /**
     * JsonPath expression evaluated against state data. True if results are not empty
     * 
     */
    @JsonProperty("condition")
    public String getCondition() {
        return condition;
    }

    /**
     * JsonPath expression evaluated against state data. True if results are not empty
     * 
     */
    @JsonProperty("condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public DataCondition withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DataCondition withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public DataCondition withEnd(End end) {
        this.end = end;
        return this;
    }

}
