/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.interfaces.WorkflowPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDefinitionKindDeserializer
extends StdDeserializer<EventDefinition.Kind> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(EventDefinitionKindDeserializer.class);
    private WorkflowPropertySource context;

    public EventDefinitionKindDeserializer() {
        this(EventDefinition.Kind.class);
    }

    public EventDefinitionKindDeserializer(WorkflowPropertySource context) {
        this(EventDefinition.Kind.class);
        this.context = context;
    }

    public EventDefinitionKindDeserializer(Class<?> vc) {
        super(vc);
    }

    public EventDefinition.Kind deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return EventDefinition.Kind.fromValue(result);
                }
                return EventDefinition.Kind.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return EventDefinition.Kind.fromValue(jp.getText());
            }
        }
        return EventDefinition.Kind.fromValue(jp.getText());
    }
}

