/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.interfaces.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.states.ParallelState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelStateCompletionTypeDeserializer
extends StdDeserializer<ParallelState.CompletionType> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(ParallelStateCompletionTypeDeserializer.class);
    private WorkflowPropertySource context;

    public ParallelStateCompletionTypeDeserializer() {
        this(ParallelState.CompletionType.class);
    }

    public ParallelStateCompletionTypeDeserializer(WorkflowPropertySource context) {
        this(ParallelState.CompletionType.class);
        this.context = context;
    }

    public ParallelStateCompletionTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    public ParallelState.CompletionType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return ParallelState.CompletionType.fromValue(result);
                }
                return ParallelState.CompletionType.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return ParallelState.CompletionType.fromValue(jp.getText());
            }
        }
        return ParallelState.CompletionType.fromValue(jp.getText());
    }
}

