/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.jbpm.serverless.workflow.api.correlation.CorrelationDef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "source", "type", "correlation", "kind", "metadata"})
public class EventDefinition
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Event Definition unique name")
    @Size(min=1)
    private @Size(min=1) String name;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="CloudEvent source UUID")
    private String source;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="CloudEvent type")
    private String type;
    @JsonProperty(value="correlation")
    @JsonPropertyDescription(value="CloudEvent correlation definitions")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<CorrelationDef> correlation = new ArrayList<CorrelationDef>();
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Defines the events as either being consumed or produced by the workflow. Default is consumed")
    private Kind kind = Kind.fromValue("consumed");
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = 6604552584694610768L;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    public EventDefinition withSource(String source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public EventDefinition withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="correlation")
    public List<CorrelationDef> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty(value="correlation")
    public void setCorrelation(List<CorrelationDef> correlation) {
        this.correlation = correlation;
    }

    public EventDefinition withCorrelation(List<CorrelationDef> correlation) {
        this.correlation = correlation;
        return this;
    }

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public EventDefinition withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public EventDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public static enum Kind {
        CONSUMED("consumed"),
        PRODUCED("produced");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

