
package org.jbpm.serverless.workflow.api.branches;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.actions.Action;


/**
 * Branch Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "actions",
    "workflowId"
})
public class Branch implements Serializable
{

    /**
     * Branch name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Branch name")
    private String name;
    /**
     * Actions to be executed in this branch
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("Actions to be executed in this branch")
    @Valid
    private List<Action> actions = new ArrayList<Action>();
    /**
     * Unique Id of a workflow to be executed in this branch
     * 
     */
    @JsonProperty("workflowId")
    @JsonPropertyDescription("Unique Id of a workflow to be executed in this branch")
    private String workflowId;
    private final static long serialVersionUID = 5772746601501045142L;

    /**
     * Branch name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Branch name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Branch withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Actions to be executed in this branch
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * Actions to be executed in this branch
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public Branch withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Unique Id of a workflow to be executed in this branch
     * 
     */
    @JsonProperty("workflowId")
    public String getWorkflowId() {
        return workflowId;
    }

    /**
     * Unique Id of a workflow to be executed in this branch
     * 
     */
    @JsonProperty("workflowId")
    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public Branch withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

}
