
package org.jbpm.serverless.workflow.api.end;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.produce.ProduceEvent;


/**
 * State end definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "kind",
    "produceEvents"
})
public class End implements Serializable
{

    /**
     * Kind of End definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @JsonPropertyDescription("Kind of End definition")
    @NotNull
    private End.Kind kind = End.Kind.fromValue("default");
    /**
     * Used if kind is event. Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    @JsonPropertyDescription("Used if kind is event. Array of events to be produced")
    @Valid
    private List<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
    private final static long serialVersionUID = 4819317724209403390L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public End() {
    }

    /**
     * 
     * @param kind
     */
    public End(End.Kind kind) {
        super();
        this.kind = kind;
    }

    /**
     * Kind of End definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public End.Kind getKind() {
        return kind;
    }

    /**
     * Kind of End definition
     * (Required)
     * 
     */
    @JsonProperty("kind")
    public void setKind(End.Kind kind) {
        this.kind = kind;
    }

    public End withKind(End.Kind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Used if kind is event. Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public List<ProduceEvent> getProduceEvents() {
        return produceEvents;
    }

    /**
     * Used if kind is event. Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public void setProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
    }

    public End withProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
        return this;
    }

    public enum Kind {

        DEFAULT("default"),
        TERMINATE("terminate"),
        EVENT("event");
        private final String value;
        private final static Map<String, End.Kind> CONSTANTS = new HashMap<String, End.Kind>();

        static {
            for (End.Kind c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Kind(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static End.Kind fromValue(String value) {
            End.Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
