
package org.jbpm.serverless.workflow.api.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.actions.Action;
import org.jbpm.serverless.workflow.api.filters.EventDataFilter;


/**
 * Actions to be performed on Events arrival
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventRefs",
    "actionMode",
    "actions",
    "eventDataFilter"
})
public class OnEvents implements Serializable
{

    /**
     * References one or more unique event names in the defined workflow events
     * (Required)
     * 
     */
    @JsonProperty("eventRefs")
    @JsonPropertyDescription("References one or more unique event names in the defined workflow events")
    @Valid
    @NotNull
    private List<String> eventRefs = new ArrayList<String>();
    /**
     * Specifies how actions are to be performed (in sequence of parallel)
     * 
     */
    @JsonProperty("actionMode")
    @JsonPropertyDescription("Specifies how actions are to be performed (in sequence of parallel)")
    private OnEvents.ActionMode actionMode = OnEvents.ActionMode.fromValue("sequential");
    /**
     * Actions to be performed.
     * (Required)
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("Actions to be performed.")
    @Valid
    @NotNull
    private List<Action> actions = new ArrayList<Action>();
    @JsonProperty("eventDataFilter")
    @Valid
    private EventDataFilter eventDataFilter;
    private final static long serialVersionUID = -6146168071991286619L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OnEvents() {
    }

    /**
     * 
     * @param eventRefs
     * @param actions
     */
    public OnEvents(List<String> eventRefs, List<Action> actions) {
        super();
        this.eventRefs = eventRefs;
        this.actions = actions;
    }

    /**
     * References one or more unique event names in the defined workflow events
     * (Required)
     * 
     */
    @JsonProperty("eventRefs")
    public List<String> getEventRefs() {
        return eventRefs;
    }

    /**
     * References one or more unique event names in the defined workflow events
     * (Required)
     * 
     */
    @JsonProperty("eventRefs")
    public void setEventRefs(List<String> eventRefs) {
        this.eventRefs = eventRefs;
    }

    public OnEvents withEventRefs(List<String> eventRefs) {
        this.eventRefs = eventRefs;
        return this;
    }

    /**
     * Specifies how actions are to be performed (in sequence of parallel)
     * 
     */
    @JsonProperty("actionMode")
    public OnEvents.ActionMode getActionMode() {
        return actionMode;
    }

    /**
     * Specifies how actions are to be performed (in sequence of parallel)
     * 
     */
    @JsonProperty("actionMode")
    public void setActionMode(OnEvents.ActionMode actionMode) {
        this.actionMode = actionMode;
    }

    public OnEvents withActionMode(OnEvents.ActionMode actionMode) {
        this.actionMode = actionMode;
        return this;
    }

    /**
     * Actions to be performed.
     * (Required)
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * Actions to be performed.
     * (Required)
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public OnEvents withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    @JsonProperty("eventDataFilter")
    public EventDataFilter getEventDataFilter() {
        return eventDataFilter;
    }

    @JsonProperty("eventDataFilter")
    public void setEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
    }

    public OnEvents withEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
        return this;
    }

    public enum ActionMode {

        SEQUENTIAL("sequential"),
        PARALLEL("parallel");
        private final String value;
        private final static Map<String, OnEvents.ActionMode> CONSTANTS = new HashMap<String, OnEvents.ActionMode>();

        static {
            for (OnEvents.ActionMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ActionMode(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OnEvents.ActionMode fromValue(String value) {
            OnEvents.ActionMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
