
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * This state is used to wait for events from event sources and then transitioning to a next state
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "timeDelay"
})
public class DelayState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Amount of time (ISO 8601 format) to delay
     * (Required)
     * 
     */
    @JsonProperty("timeDelay")
    @JsonPropertyDescription("Amount of time (ISO 8601 format) to delay")
    @NotNull
    private java.lang.String timeDelay;
    private final static long serialVersionUID = 3710873655752660284L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DelayState() {
    }

    /**
     * 
     * @param name
     * @param timeDelay
     * @param type
     */
    public DelayState(java.lang.String timeDelay, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.timeDelay = timeDelay;
    }

    /**
     * Amount of time (ISO 8601 format) to delay
     * (Required)
     * 
     */
    @JsonProperty("timeDelay")
    public java.lang.String getTimeDelay() {
        return timeDelay;
    }

    /**
     * Amount of time (ISO 8601 format) to delay
     * (Required)
     * 
     */
    @JsonProperty("timeDelay")
    public void setTimeDelay(java.lang.String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public DelayState withTimeDelay(java.lang.String timeDelay) {
        this.timeDelay = timeDelay;
        return this;
    }

    @Override
    public DelayState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public DelayState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DelayState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public DelayState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public DelayState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public DelayState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public DelayState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public DelayState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public DelayState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public DelayState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public DelayState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public DelayState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
