
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.defaultdef.DefaultDefinition;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.switchconditions.DataCondition;
import org.jbpm.serverless.workflow.api.switchconditions.EventCondition;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Permits transitions to other states based on criteria matching
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventConditions",
    "dataConditions",
    "eventTimeout",
    "default"
})
public class SwitchState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Defines conditions evaluated against events
     * 
     */
    @JsonProperty("eventConditions")
    @JsonPropertyDescription("Defines conditions evaluated against events")
    @Valid
    private List<EventCondition> eventConditions = new ArrayList<EventCondition>();
    /**
     * Defines conditions evaluated against state data
     * 
     */
    @JsonProperty("dataConditions")
    @JsonPropertyDescription("Defines conditions evaluated against state data")
    @Valid
    private List<DataCondition> dataConditions = new ArrayList<DataCondition>();
    /**
     * If eventConditions is used, defines the time period to wait for events (ISO 8601 format)
     * 
     */
    @JsonProperty("eventTimeout")
    @JsonPropertyDescription("If eventConditions is used, defines the time period to wait for events (ISO 8601 format)")
    private java.lang.String eventTimeout;
    /**
     * Switch state default definition
     * (Required)
     * 
     */
    @JsonProperty("default")
    @JsonPropertyDescription("Switch state default definition")
    @Valid
    @NotNull
    private DefaultDefinition _default;
    private final static long serialVersionUID = -1542217108363176876L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SwitchState() {
    }

    /**
     * 
     * @param _default
     * @param name
     * @param type
     */
    public SwitchState(DefaultDefinition _default, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this._default = _default;
    }

    /**
     * Defines conditions evaluated against events
     * 
     */
    @JsonProperty("eventConditions")
    public List<EventCondition> getEventConditions() {
        return eventConditions;
    }

    /**
     * Defines conditions evaluated against events
     * 
     */
    @JsonProperty("eventConditions")
    public void setEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
    }

    public SwitchState withEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
        return this;
    }

    /**
     * Defines conditions evaluated against state data
     * 
     */
    @JsonProperty("dataConditions")
    public List<DataCondition> getDataConditions() {
        return dataConditions;
    }

    /**
     * Defines conditions evaluated against state data
     * 
     */
    @JsonProperty("dataConditions")
    public void setDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
    }

    public SwitchState withDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
        return this;
    }

    /**
     * If eventConditions is used, defines the time period to wait for events (ISO 8601 format)
     * 
     */
    @JsonProperty("eventTimeout")
    public java.lang.String getEventTimeout() {
        return eventTimeout;
    }

    /**
     * If eventConditions is used, defines the time period to wait for events (ISO 8601 format)
     * 
     */
    @JsonProperty("eventTimeout")
    public void setEventTimeout(java.lang.String eventTimeout) {
        this.eventTimeout = eventTimeout;
    }

    public SwitchState withEventTimeout(java.lang.String eventTimeout) {
        this.eventTimeout = eventTimeout;
        return this;
    }

    /**
     * Switch state default definition
     * (Required)
     * 
     */
    @JsonProperty("default")
    public DefaultDefinition getDefault() {
        return _default;
    }

    /**
     * Switch state default definition
     * (Required)
     * 
     */
    @JsonProperty("default")
    public void setDefault(DefaultDefinition _default) {
        this._default = _default;
    }

    public SwitchState withDefault(DefaultDefinition _default) {
        this._default = _default;
        return this;
    }

    @Override
    public SwitchState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SwitchState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SwitchState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SwitchState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public SwitchState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SwitchState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SwitchState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SwitchState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SwitchState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public SwitchState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public SwitchState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public SwitchState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
