
package org.jbpm.serverless.workflow.api.transitions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.produce.ProduceEvent;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "expression",
    "produceEvents",
    "nextState"
})
public class Transition implements Serializable
{

    /**
     * Common Expression Language (CEL) expression. Must evaluate to true for the transition to be valid
     * 
     */
    @JsonProperty("expression")
    @JsonPropertyDescription("Common Expression Language (CEL) expression. Must evaluate to true for the transition to be valid")
    private String expression;
    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    @JsonPropertyDescription("Array of events to be produced")
    @Valid
    private List<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    @JsonPropertyDescription("State to transition to next")
    @Size(min = 1)
    @NotNull
    private String nextState;
    private final static long serialVersionUID = -5310376927074575509L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Transition() {
    }

    /**
     * 
     * @param nextState
     */
    public Transition(String nextState) {
        super();
        this.nextState = nextState;
    }

    /**
     * Common Expression Language (CEL) expression. Must evaluate to true for the transition to be valid
     * 
     */
    @JsonProperty("expression")
    public String getExpression() {
        return expression;
    }

    /**
     * Common Expression Language (CEL) expression. Must evaluate to true for the transition to be valid
     * 
     */
    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Transition withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public List<ProduceEvent> getProduceEvents() {
        return produceEvents;
    }

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public void setProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
    }

    public Transition withProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
        return this;
    }

    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    public String getNextState() {
        return nextState;
    }

    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    public Transition withNextState(String nextState) {
        this.nextState = nextState;
        return this;
    }

}
