/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.workflow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.jbpm.serverless.workflow.api.Workflow;
import org.jbpm.serverless.workflow.api.mapper.JsonObjectMapper;
import org.jbpm.serverless.workflow.api.mapper.YamlObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWorkflow {
    private static JsonObjectMapper jsonObjectMapper = new JsonObjectMapper();
    private static YamlObjectMapper yamlObjectMapper = new YamlObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(BaseWorkflow.class);

    public static Workflow fromSource(String source) {
        try {
            return (Workflow)jsonObjectMapper.readValue(source, Workflow.class);
        }
        catch (Exception e) {
            try {
                return (Workflow)yamlObjectMapper.readValue(source, Workflow.class);
            }
            catch (Exception ee) {
                throw new IllegalArgumentException("Could not convert markup to Workflow: " + ee.getMessage());
            }
        }
    }

    public static String toJson(Workflow workflow) {
        try {
            return jsonObjectMapper.writeValueAsString(workflow);
        }
        catch (JsonProcessingException e) {
            logger.error("Error mapping to json: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String toYaml(Workflow workflow) {
        try {
            JsonNode jsonNode = jsonObjectMapper.valueToTree(workflow);
            YAMLFactory yamlFactory = new YAMLFactory().disable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
            return new YAMLMapper(yamlFactory).writeValueAsString((Object)jsonNode);
        }
        catch (Exception e) {
            logger.error("Error mapping to yaml: {}", (Object)e.getMessage());
            return null;
        }
    }
}

