
package org.jbpm.serverless.workflow.api.correlation;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * CloudEvent correlation definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "contextAttributeName",
    "contextAttributeValue"
})
public class CorrelationDef implements Serializable
{

    /**
     * CloudEvent Extension Context Attribute name
     * (Required)
     * 
     */
    @JsonProperty("contextAttributeName")
    @JsonPropertyDescription("CloudEvent Extension Context Attribute name")
    @Size(min = 1)
    @NotNull
    private String contextAttributeName;
    /**
     * CloudEvent Extension Context Attribute value
     * 
     */
    @JsonProperty("contextAttributeValue")
    @JsonPropertyDescription("CloudEvent Extension Context Attribute value")
    @Size(min = 1)
    private String contextAttributeValue;
    private final static long serialVersionUID = 2147125052946629459L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CorrelationDef() {
    }

    /**
     * 
     * @param contextAttributeName
     */
    public CorrelationDef(String contextAttributeName) {
        super();
        this.contextAttributeName = contextAttributeName;
    }

    /**
     * CloudEvent Extension Context Attribute name
     * (Required)
     * 
     */
    @JsonProperty("contextAttributeName")
    public String getContextAttributeName() {
        return contextAttributeName;
    }

    /**
     * CloudEvent Extension Context Attribute name
     * (Required)
     * 
     */
    @JsonProperty("contextAttributeName")
    public void setContextAttributeName(String contextAttributeName) {
        this.contextAttributeName = contextAttributeName;
    }

    public CorrelationDef withContextAttributeName(String contextAttributeName) {
        this.contextAttributeName = contextAttributeName;
        return this;
    }

    /**
     * CloudEvent Extension Context Attribute value
     * 
     */
    @JsonProperty("contextAttributeValue")
    public String getContextAttributeValue() {
        return contextAttributeValue;
    }

    /**
     * CloudEvent Extension Context Attribute value
     * 
     */
    @JsonProperty("contextAttributeValue")
    public void setContextAttributeValue(String contextAttributeValue) {
        this.contextAttributeValue = contextAttributeValue;
    }

    public CorrelationDef withContextAttributeValue(String contextAttributeValue) {
        this.contextAttributeValue = contextAttributeValue;
        return this;
    }

}
