
package org.jbpm.serverless.workflow.api.events;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Event References
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "triggerEventRef",
    "resultEventRef",
    "data",
    "contextAttributes"
})
public class EventRef implements Serializable
{

    /**
     * Reference to the unique name of a 'produced' event definition
     * (Required)
     * 
     */
    @JsonProperty("triggerEventRef")
    @JsonPropertyDescription("Reference to the unique name of a 'produced' event definition")
    @NotNull
    private java.lang.String triggerEventRef;
    /**
     * Reference to the unique name of a 'consumed' event definition
     * (Required)
     * 
     */
    @JsonProperty("resultEventRef")
    @JsonPropertyDescription("Reference to the unique name of a 'consumed' event definition")
    @NotNull
    private java.lang.String resultEventRef;
    /**
     * Expression which selects parts of the states data output to become the data of the produced event.
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("Expression which selects parts of the states data output to become the data of the produced event.")
    private java.lang.String data;
    /**
     * Add additional extension context attributes to the produced event
     * 
     */
    @JsonProperty("contextAttributes")
    @JsonPropertyDescription("Add additional extension context attributes to the produced event")
    @Valid
    private Map<String, String> contextAttributes;
    private final static long serialVersionUID = -4668447908590067979L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventRef() {
    }

    /**
     * 
     * @param resultEventRef
     * @param triggerEventRef
     */
    public EventRef(java.lang.String triggerEventRef, java.lang.String resultEventRef) {
        super();
        this.triggerEventRef = triggerEventRef;
        this.resultEventRef = resultEventRef;
    }

    /**
     * Reference to the unique name of a 'produced' event definition
     * (Required)
     * 
     */
    @JsonProperty("triggerEventRef")
    public java.lang.String getTriggerEventRef() {
        return triggerEventRef;
    }

    /**
     * Reference to the unique name of a 'produced' event definition
     * (Required)
     * 
     */
    @JsonProperty("triggerEventRef")
    public void setTriggerEventRef(java.lang.String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
    }

    public EventRef withTriggerEventRef(java.lang.String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
        return this;
    }

    /**
     * Reference to the unique name of a 'consumed' event definition
     * (Required)
     * 
     */
    @JsonProperty("resultEventRef")
    public java.lang.String getResultEventRef() {
        return resultEventRef;
    }

    /**
     * Reference to the unique name of a 'consumed' event definition
     * (Required)
     * 
     */
    @JsonProperty("resultEventRef")
    public void setResultEventRef(java.lang.String resultEventRef) {
        this.resultEventRef = resultEventRef;
    }

    public EventRef withResultEventRef(java.lang.String resultEventRef) {
        this.resultEventRef = resultEventRef;
        return this;
    }

    /**
     * Expression which selects parts of the states data output to become the data of the produced event.
     * 
     */
    @JsonProperty("data")
    public java.lang.String getData() {
        return data;
    }

    /**
     * Expression which selects parts of the states data output to become the data of the produced event.
     * 
     */
    @JsonProperty("data")
    public void setData(java.lang.String data) {
        this.data = data;
    }

    public EventRef withData(java.lang.String data) {
        this.data = data;
        return this;
    }

    /**
     * Add additional extension context attributes to the produced event
     * 
     */
    @JsonProperty("contextAttributes")
    public Map<String, String> getContextAttributes() {
        return contextAttributes;
    }

    /**
     * Add additional extension context attributes to the produced event
     * 
     */
    @JsonProperty("contextAttributes")
    public void setContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public EventRef withContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
        return this;
    }

}
