
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.branches.Branch;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Consists of a number of states that are executed in parallel
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "branches",
    "completionType",
    "n"
})
public class ParallelState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    @JsonPropertyDescription("Branch Definitions")
    @Valid
    @NotNull
    private List<Branch> branches = new ArrayList<Branch>();
    /**
     * Option types on how to complete branch execution.
     * 
     */
    @JsonProperty("completionType")
    @JsonPropertyDescription("Option types on how to complete branch execution.")
    private ParallelState.CompletionType completionType = ParallelState.CompletionType.fromValue("and");
    /**
     * Used when completionType is set to 'n_of_m' to specify the 'N' value
     * 
     */
    @JsonProperty("n")
    @JsonPropertyDescription("Used when completionType is set to 'n_of_m' to specify the 'N' value")
    private java.lang.String n = "0";
    private final static long serialVersionUID = -8296508061422605652L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParallelState() {
    }

    /**
     * 
     * @param name
     * @param branches
     * @param type
     */
    public ParallelState(List<Branch> branches, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.branches = branches;
    }

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    public List<Branch> getBranches() {
        return branches;
    }

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public ParallelState withBranches(List<Branch> branches) {
        this.branches = branches;
        return this;
    }

    /**
     * Option types on how to complete branch execution.
     * 
     */
    @JsonProperty("completionType")
    public ParallelState.CompletionType getCompletionType() {
        return completionType;
    }

    /**
     * Option types on how to complete branch execution.
     * 
     */
    @JsonProperty("completionType")
    public void setCompletionType(ParallelState.CompletionType completionType) {
        this.completionType = completionType;
    }

    public ParallelState withCompletionType(ParallelState.CompletionType completionType) {
        this.completionType = completionType;
        return this;
    }

    /**
     * Used when completionType is set to 'n_of_m' to specify the 'N' value
     * 
     */
    @JsonProperty("n")
    public java.lang.String getN() {
        return n;
    }

    /**
     * Used when completionType is set to 'n_of_m' to specify the 'N' value
     * 
     */
    @JsonProperty("n")
    public void setN(java.lang.String n) {
        this.n = n;
    }

    public ParallelState withN(java.lang.String n) {
        this.n = n;
        return this;
    }

    @Override
    public ParallelState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ParallelState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ParallelState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ParallelState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public ParallelState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ParallelState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ParallelState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ParallelState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ParallelState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public ParallelState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public ParallelState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public ParallelState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

    public enum CompletionType {

        AND("and"),
        XOR("xor"),
        N_OF_M("n_of_m");
        private final java.lang.String value;
        private final static Map<java.lang.String, ParallelState.CompletionType> CONSTANTS = new HashMap<java.lang.String, ParallelState.CompletionType>();

        static {
            for (ParallelState.CompletionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private CompletionType(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static ParallelState.CompletionType fromValue(java.lang.String value) {
            ParallelState.CompletionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
