
package org.jbpm.serverless.workflow.api.switchconditions;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.filters.EventDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.SwitchCondition;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Switch state data event condition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventRef",
    "eventDataFilter",
    "transition",
    "end"
})
public class EventCondition implements Serializable, SwitchCondition
{

    /**
     * References an unique event name in the defined workflow events
     * 
     */
    @JsonProperty("eventRef")
    @JsonPropertyDescription("References an unique event name in the defined workflow events")
    private String eventRef;
    @JsonProperty("eventDataFilter")
    @Valid
    private EventDataFilter eventDataFilter;
    @JsonProperty("transition")
    @Valid
    private Transition transition;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    private final static long serialVersionUID = -3663233259837166524L;

    /**
     * References an unique event name in the defined workflow events
     * 
     */
    @JsonProperty("eventRef")
    public String getEventRef() {
        return eventRef;
    }

    /**
     * References an unique event name in the defined workflow events
     * 
     */
    @JsonProperty("eventRef")
    public void setEventRef(String eventRef) {
        this.eventRef = eventRef;
    }

    public EventCondition withEventRef(String eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    @JsonProperty("eventDataFilter")
    public EventDataFilter getEventDataFilter() {
        return eventDataFilter;
    }

    @JsonProperty("eventDataFilter")
    public void setEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
    }

    public EventCondition withEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
        return this;
    }

    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public EventCondition withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public EventCondition withEnd(End end) {
        this.end = end;
        return this;
    }

}
