/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.serverless.workflow.api.interfaces.Extension;
import org.jbpm.serverless.workflow.api.interfaces.WorkflowPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDeserializer
extends StdDeserializer<Extension> {
    private WorkflowPropertySource context;
    private Map<String, Class<? extends Extension>> extensionsMap = new HashMap<String, Class<? extends Extension>>();
    private static Logger logger = LoggerFactory.getLogger(ExtensionDeserializer.class);

    public ExtensionDeserializer() {
        this(Extension.class);
    }

    public ExtensionDeserializer(Class<?> vc) {
        super(vc);
    }

    public ExtensionDeserializer(WorkflowPropertySource context) {
        this(Extension.class);
        this.context = context;
    }

    public void addExtension(String extensionId, Class<? extends Extension> extensionClass) {
        this.extensionsMap.put(extensionId, extensionClass);
    }

    public Extension deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String extensionId = node.get("extensionid").asText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(extensionId);
                if (result != null) {
                    extensionId = result;
                }
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
            }
        }
        if (this.extensionsMap != null && this.extensionsMap.containsKey(extensionId)) {
            return (Extension)mapper.treeToValue((TreeNode)node, this.extensionsMap.get(extensionId));
        }
        throw new IllegalArgumentException("Extension handler not registered for: " + extensionId);
    }
}

