/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.interfaces.WorkflowPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringValueDeserializer
extends StdDeserializer<String> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(StringValueDeserializer.class);
    private WorkflowPropertySource context;

    public StringValueDeserializer() {
        this(String.class);
    }

    public StringValueDeserializer(WorkflowPropertySource context) {
        this(String.class);
        this.context = context;
    }

    public StringValueDeserializer(Class<?> vc) {
        super(vc);
    }

    public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return result;
                }
                return jp.getText();
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return jp.getText();
            }
        }
        return jp.getText();
    }
}

