/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.retry;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"expression", "interval", "multiplier", "maxAttempts"})
public class Retry
implements Serializable {
    @JsonProperty(value="expression")
    @JsonPropertyDescription(value="Common Expression Language (CEL) expression. Should be evaluated against state data. Must evaluate to true for retry to execute")
    @NotNull
    private String expression;
    @JsonProperty(value="interval")
    @JsonPropertyDescription(value="Specifies the amount of time between retries (ISO 8601 format)")
    private String interval;
    @JsonProperty(value="multiplier")
    @JsonPropertyDescription(value="Multiplier value by which interval increases during each attempt (ISO 8601 time format)")
    private String multiplier;
    @JsonProperty(value="maxAttempts")
    @JsonPropertyDescription(value="Maximum number of retry attempts (1 by default). Value of 0 means no retries are performed")
    private String maxAttempts = "0";
    private static final long serialVersionUID = 4543196099810868918L;

    public Retry() {
    }

    public Retry(String expression) {
        this.expression = expression;
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Retry withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Retry withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    @JsonProperty(value="multiplier")
    public String getMultiplier() {
        return this.multiplier;
    }

    @JsonProperty(value="multiplier")
    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public Retry withMultiplier(String multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @JsonProperty(value="maxAttempts")
    public String getMaxAttempts() {
        return this.maxAttempts;
    }

    @JsonProperty(value="maxAttempts")
    public void setMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Retry withMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }
}

