/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jbpm.usertask.handler;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.impl.DefaultKogitoWorkItemHandler;
import org.kie.kogito.usertask.UserTask;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.UserTasks;
import org.kie.kogito.usertask.impl.DefaultUserTaskInstance;
import org.kie.kogito.usertask.impl.model.DeadlineHelper;

public class UserTaskKogitoWorkItemHandler
extends DefaultKogitoWorkItemHandler {
    private static String UT_SEPARATOR = System.getProperty("org.jbpm.ht.user.separator", ",");
    private static final String DESCRIPTION = "Description";
    private static final String PRIORITY = "Priority";
    private static final String TASK_NAME = "TaskName";
    private static final String NODE_NAME = "NodeName";
    private static final String ACTOR_ID = "ActorId";
    private static final String GROUP_ID = "GroupId";
    private static final String BUSINESSADMINISTRATOR_ID = "BusinessAdministratorId";
    private static final String BUSINESSADMINISTRATOR_GROUP_ID = "BusinessAdministratorGroupId";
    private static final String EXCLUDED_OWNER_ID = "ExcludedOwnerId";
    private static final String NOT_STARTED_NOTIFY = "NotStartedNotify";
    private static final String NOT_STARTED_REASSIGN = "NotStartedReassign";
    private static final String NOT_COMPLETED_NOTIFY = "NotCompletedNotify";
    private static final String NOT_COMPLETED_REASSIGN = "NotCompletedReassign";

    public UserTaskKogitoWorkItemHandler() {
    }

    public UserTaskKogitoWorkItemHandler(Application application) {
        this.setApplication(application);
    }

    public Optional<WorkItemTransition> activateWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workItem, WorkItemTransition transition) {
        UserTasks userTasks = (UserTasks)handler.getApplication().get(UserTasks.class);
        Object priority = workItem.getParameter(PRIORITY);
        UserTask userTask = userTasks.userTaskById((String)workItem.getParameter("UNIQUE_TASK_ID"));
        DefaultUserTaskInstance instance = (DefaultUserTaskInstance)userTask.createInstance();
        instance.setExternalReferenceId(workItem.getStringId());
        userTask.instances().create((UserTaskInstance)instance);
        instance.setTaskName(Optional.ofNullable((String)workItem.getParameter(TASK_NAME)).orElse((String)workItem.getParameter(NODE_NAME)));
        instance.setTaskDescription((String)workItem.getParameter(DESCRIPTION));
        instance.setTaskPriority(priority != null ? priority.toString() : null);
        instance.setSlaDueDate(workItem.getNodeInstance().getSlaDueDate());
        instance.setMetadata("ProcessId", (Object)workItem.getProcessInstance().getProcessId());
        instance.setMetadata("ProcessType", (Object)workItem.getProcessInstance().getProcess().getType());
        instance.setMetadata("ProcessVersion", (Object)workItem.getProcessInstance().getProcessVersion());
        instance.setMetadata("ProcessInstanceId", (Object)workItem.getProcessInstance().getId());
        instance.setMetadata("ProcessInstanceState", (Object)workItem.getProcessInstance().getState());
        instance.setMetadata("RootProcessId", (Object)workItem.getProcessInstance().getRootProcessId());
        instance.setMetadata("RootProcessInstanceId", (Object)workItem.getProcessInstance().getRootProcessInstanceId());
        instance.setMetadata("ParentProcessInstanceId", (Object)workItem.getProcessInstance().getParentProcessInstanceId());
        instance.setMetadata("NodeInstanceId", (Object)workItem.getNodeInstance().getId());
        instance.fireInitialStateChange();
        workItem.getParameters().entrySet().stream().filter(e -> !HumanTaskNode.TASK_PARAMETERS.contains(e.getKey())).forEach(e -> instance.setInput((String)e.getKey(), e.getValue()));
        Optional.ofNullable(workItem.getParameters().get(ACTOR_ID)).map(String.class::cast).map(this::toSet).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setPotentialUsers(arg_0));
        Optional.ofNullable(workItem.getParameters().get(GROUP_ID)).map(String.class::cast).map(this::toSet).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setPotentialGroups(arg_0));
        Optional.ofNullable(workItem.getParameters().get(BUSINESSADMINISTRATOR_ID)).map(String.class::cast).map(this::toSet).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setAdminUsers(arg_0));
        Optional.ofNullable(workItem.getParameters().get(BUSINESSADMINISTRATOR_GROUP_ID)).map(String.class::cast).map(this::toSet).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setAdminGroups(arg_0));
        Optional.ofNullable(workItem.getParameters().get(EXCLUDED_OWNER_ID)).map(String.class::cast).map(this::toSet).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setExcludedUsers(arg_0));
        Optional.ofNullable(workItem.getParameters().get(NOT_STARTED_NOTIFY)).map(String.class::cast).map(DeadlineHelper::parseDeadlines).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setNotStartedDeadlines(arg_0));
        Optional.ofNullable(workItem.getParameters().get(NOT_STARTED_REASSIGN)).map(String.class::cast).map(DeadlineHelper::parseReassignments).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setNotStartedReassignments(arg_0));
        Optional.ofNullable(workItem.getParameters().get(NOT_COMPLETED_NOTIFY)).map(String.class::cast).map(DeadlineHelper::parseDeadlines).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setNotCompletedDeadlines(arg_0));
        Optional.ofNullable(workItem.getParameters().get(NOT_COMPLETED_REASSIGN)).map(String.class::cast).map(DeadlineHelper::parseReassignments).ifPresent(arg_0 -> ((DefaultUserTaskInstance)instance).setNotCompletedReassignments(arg_0));
        instance.initialize(Collections.emptyMap(), IdentityProviders.of((String)"WORKFLOW_ENGINE_USER", (String[])new String[0]));
        if (workItem instanceof InternalKogitoWorkItem) {
            InternalKogitoWorkItem ikw = (InternalKogitoWorkItem)workItem;
            ikw.setExternalReferenceId(instance.getId());
            ikw.setActualOwner(instance.getActualOwner());
        }
        return Optional.empty();
    }

    public Optional<WorkItemTransition> completeWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workItem, WorkItemTransition transition) {
        if (transition.data().containsKey("Notify")) {
            return Optional.empty();
        }
        UserTasks userTasks = (UserTasks)handler.getApplication().get(UserTasks.class);
        UserTask userTask = userTasks.userTaskById((String)workItem.getParameter("UNIQUE_TASK_ID"));
        userTask.instances().findById(workItem.getExternalReferenceId()).ifPresent(ut -> {
            if (workItem instanceof InternalKogitoWorkItem) {
                InternalKogitoWorkItem ikw = (InternalKogitoWorkItem)workItem;
                ikw.setActualOwner(ut.getActualOwner());
            }
            ut.transition("skip", Collections.singletonMap("NOTIFY", Boolean.FALSE), IdentityProviders.of((String)"WORKFLOW_ENGINE_USER", (String[])new String[0]));
        });
        return Optional.empty();
    }

    public Optional<WorkItemTransition> abortWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workItem, WorkItemTransition transition) {
        if (transition.data().containsKey("Notify")) {
            return Optional.empty();
        }
        UserTasks userTasks = (UserTasks)handler.getApplication().get(UserTasks.class);
        UserTask userTask = userTasks.userTaskById((String)workItem.getParameter("UNIQUE_TASK_ID"));
        userTask.instances().findById(workItem.getExternalReferenceId()).ifPresent(ut -> {
            if (workItem instanceof InternalKogitoWorkItem) {
                InternalKogitoWorkItem ikw = (InternalKogitoWorkItem)workItem;
                ikw.setActualOwner(ut.getActualOwner());
            }
            ut.transition("fail", Collections.singletonMap("NOTIFY", Boolean.FALSE), IdentityProviders.of((String)"WORKFLOW_ENGINE_USER", (String[])new String[0]));
        });
        return Optional.empty();
    }

    protected Set<String> toSet(String value) {
        if (value == null) {
            return null;
        }
        return Set.of(value.split(UT_SEPARATOR));
    }

    public String getName() {
        return "Human Task";
    }
}

