/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jbpm.usertask.handler;

import java.util.HashMap;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.process.Processes;
import org.kie.kogito.usertask.UserTaskEventListener;
import org.kie.kogito.usertask.events.UserTaskStateEvent;
import org.kie.kogito.usertask.lifecycle.UserTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskKogitoWorkItemHandlerProcessListener
implements UserTaskEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserTaskKogitoWorkItemHandlerProcessListener.class);
    private Processes processes;

    public UserTaskKogitoWorkItemHandlerProcessListener(Processes processes) {
        this.processes = processes;
    }

    public void onUserTaskState(UserTaskStateEvent event) {
        UserTaskState userTaskState = event.getNewStatus();
        if (!userTaskState.isTerminate()) {
            return;
        }
        Boolean notify = (Boolean)event.getUserTaskInstance().getMetadata().get("NOTIFY");
        if (notify != null && !notify.booleanValue()) {
            return;
        }
        LOG.debug("onUserTaskState {} on complete work item", (Object)event);
        String processId = (String)event.getUserTaskInstance().getMetadata().get("ProcessId");
        String processInstanceId = (String)event.getUserTaskInstance().getMetadata().get("ProcessInstanceId");
        this.processes.processById(processId).instances().findById(processInstanceId).ifPresent(pi -> {
            HashMap<String, Object> data = new HashMap<String, Object>(event.getUserTaskInstance().getOutputs());
            data.put("ActorId", event.getUserTaskInstance().getActualOwner());
            data.put("Notify", false);
            pi.completeWorkItem(event.getUserTaskInstance().getExternalReferenceId(), data, new Policy[0]);
        });
    }
}

