/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.internal.usertask.event.KogitoUserTaskEventSupport;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.descriptors.UserTaskInstanceJobDescription;
import org.kie.kogito.usertask.UserTask;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.UserTaskInstances;
import org.kie.kogito.usertask.impl.model.DeadlineHelper;
import org.kie.kogito.usertask.lifecycle.UserTaskLifeCycle;
import org.kie.kogito.usertask.lifecycle.UserTaskState;
import org.kie.kogito.usertask.lifecycle.UserTaskTransitionToken;
import org.kie.kogito.usertask.model.Attachment;
import org.kie.kogito.usertask.model.Comment;
import org.kie.kogito.usertask.model.DeadlineInfo;
import org.kie.kogito.usertask.model.Notification;
import org.kie.kogito.usertask.model.Reassignment;
import org.kie.kogito.usertask.model.ScheduleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserTaskInstance
implements UserTaskInstance {
    private static Logger LOG = LoggerFactory.getLogger(DefaultUserTaskInstance.class);
    private String id;
    private String userTaskId;
    private UserTaskState status;
    private String actualOwner;
    private String taskName;
    private String taskDescription;
    private String taskPriority;
    private Set<String> potentialUsers;
    private Set<String> potentialGroups;
    private Set<String> adminUsers;
    private Set<String> adminGroups;
    private Set<String> excludedUsers;
    private List<Attachment> attachments;
    private List<Comment> comments;
    private String externalReferenceId;
    private Date slaDueDate;
    private Map<String, Object> inputs = new HashMap<String, Object>();
    private Map<String, Object> outputs = new HashMap<String, Object>();
    private Map<String, Object> metadata;
    @JsonIgnore
    private UserTaskInstances instances;
    @JsonIgnore
    private UserTask userTask;
    @JsonIgnore
    private KogitoUserTaskEventSupport userTaskEventSupport;
    @JsonIgnore
    private UserTaskLifeCycle userTaskLifeCycle;
    @JsonIgnore
    private JobsService jobsService;
    private Collection<DeadlineInfo<Notification>> notStartedDeadlines;
    private Collection<DeadlineInfo<Notification>> notCompletedDeadlines;
    private Collection<DeadlineInfo<Reassignment>> notStartedReassignments;
    private Collection<DeadlineInfo<Reassignment>> notCompletedReassignments;
    private Map<String, Notification> notStartedDeadlinesTimers;
    private Map<String, Notification> notCompletedDeadlinesTimers;
    private Map<String, Reassignment> notStartedReassignmentsTimers;
    private Map<String, Reassignment> notCompletedReassignmentsTimers;

    public DefaultUserTaskInstance() {
        this.status = UserTaskState.initalized();
        this.metadata = new HashMap<String, Object>();
        this.attachments = new ArrayList<Attachment>();
        this.comments = new ArrayList<Comment>();
        this.potentialUsers = new HashSet<String>();
        this.potentialGroups = new HashSet<String>();
        this.adminUsers = new HashSet<String>();
        this.adminGroups = new HashSet<String>();
        this.excludedUsers = new HashSet<String>();
        this.notStartedDeadlinesTimers = new HashMap<String, Notification>();
        this.notCompletedDeadlinesTimers = new HashMap<String, Notification>();
        this.notStartedReassignmentsTimers = new HashMap<String, Reassignment>();
        this.notCompletedReassignmentsTimers = new HashMap<String, Reassignment>();
    }

    public DefaultUserTaskInstance(UserTask userTask) {
        this();
        this.id = UUID.randomUUID().toString();
        this.userTask = userTask;
    }

    public Map<String, Notification> getNotCompletedDeadlinesTimers() {
        return this.notCompletedDeadlinesTimers;
    }

    public void setNotCompletedDeadlinesTimers(Map<String, Notification> notCompletedDeadlinesTimers) {
        this.notCompletedDeadlinesTimers = notCompletedDeadlinesTimers;
    }

    public Map<String, Reassignment> getNotCompletedReassignmentsTimers() {
        return this.notCompletedReassignmentsTimers;
    }

    public void setNotCompletedReassignmentsTimers(Map<String, Reassignment> notCompletedReassignmentsTimers) {
        this.notCompletedReassignmentsTimers = notCompletedReassignmentsTimers;
    }

    public Map<String, Notification> getNotStartedDeadlinesTimers() {
        return this.notStartedDeadlinesTimers;
    }

    public void setNotStartedDeadlinesTimers(Map<String, Notification> notStartedDeadlinesTimers) {
        this.notStartedDeadlinesTimers = notStartedDeadlinesTimers;
    }

    public Map<String, Reassignment> getNotStartedReassignmentsTimers() {
        return this.notStartedReassignmentsTimers;
    }

    public void setNotStartedReassignmentsTimers(Map<String, Reassignment> notStartedReassignmentsTimers) {
        this.notStartedReassignmentsTimers = notStartedReassignmentsTimers;
    }

    public void setUserTaskEventSupport(KogitoUserTaskEventSupport userTaskEventSupport) {
        this.userTaskEventSupport = userTaskEventSupport;
    }

    public void setUserTaskLifeCycle(UserTaskLifeCycle userTaskLifeCycle) {
        this.userTaskLifeCycle = userTaskLifeCycle;
    }

    public UserTaskLifeCycle getUserTaskLifeCycle() {
        return this.userTaskLifeCycle;
    }

    public void setInstances(UserTaskInstances instances) {
        this.instances = instances;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserTaskId() {
        return this.userTaskId;
    }

    public void setUserTaskId(String userTaskId) {
        this.userTaskId = userTaskId;
    }

    public String getId() {
        return this.id;
    }

    public void setStatus(UserTaskState status) {
        this.status = status;
    }

    public UserTaskState getStatus() {
        return this.status;
    }

    public boolean hasActualOwner() {
        return this.actualOwner != null;
    }

    public void setActualOwner(String actualOwner) {
        this.actualOwner = actualOwner;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOneUserTaskStateChange((UserTaskInstance)this, this.status, this.status);
        }
        this.updatePersistence();
    }

    public String getActualOwner() {
        return this.actualOwner;
    }

    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void setSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public void initialize(Map<String, Object> data, IdentityProvider identity) {
        this.transition(this.userTaskLifeCycle.startTransition(), data, identity);
    }

    public void transition(String transitionId, Map<String, Object> data, IdentityProvider identity) {
        Optional next = Optional.of(this.userTaskLifeCycle.newTransitionToken(transitionId, (UserTaskInstance)this, data));
        while (next.isPresent()) {
            UserTaskTransitionToken transition = next.get();
            next = this.userTaskLifeCycle.transition((UserTaskInstance)this, transition, identity);
            this.status = transition.target();
            this.userTaskEventSupport.fireOneUserTaskStateChange((UserTaskInstance)this, transition.source(), transition.target());
        }
        this.updatePersistenceOrRemove();
    }

    private void updatePersistence() {
        if (this.instances != null) {
            this.instances.update((UserTaskInstance)this);
        }
    }

    private void updatePersistenceOrRemove() {
        if (this.status.isTerminate()) {
            this.instances.remove((UserTaskInstance)this);
        } else {
            this.instances.update((UserTaskInstance)this);
        }
    }

    public UserTask getUserTask() {
        return this.userTask;
    }

    public void setUserTask(UserTask userTask) {
        this.userTask = userTask;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, Object> outputs) {
        this.outputs = outputs;
    }

    public void setInput(String key, Object newValue) {
        Object oldValue = this.inputs.put(key, newValue);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskInputVariableChange((UserTaskInstance)this, key, newValue, oldValue);
        }
        this.updatePersistence();
    }

    public void setOutput(String key, Object newValue) {
        Object oldValue = this.outputs.put(key, newValue);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskOutputVariableChange((UserTaskInstance)this, key, newValue, oldValue);
        }
        this.updatePersistence();
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOneUserTaskStateChange((UserTaskInstance)this, this.status, this.status);
        }
        this.updatePersistence();
    }

    public void fireInitialStateChange() {
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOneUserTaskStateChange((UserTaskInstance)this, this.status, this.status);
        }
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOneUserTaskStateChange((UserTaskInstance)this, this.status, this.status);
        }
        this.updatePersistence();
    }

    public String getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(String taskPriority) {
        this.taskPriority = taskPriority;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOneUserTaskStateChange((UserTaskInstance)this, this.status, this.status);
        }
        this.updatePersistence();
    }

    public Set<String> getPotentialUsers() {
        return this.potentialUsers;
    }

    public void setPotentialUsers(Set<String> potentialUsers) {
        HashSet<String> oldValues = new HashSet<String>(this.potentialUsers);
        this.potentialUsers = potentialUsers;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAssignmentChange((UserTaskInstance)this, KogitoUserTaskEventSupport.AssignmentType.USER_OWNERS, oldValues, potentialUsers);
        }
        this.updatePersistence();
    }

    public Set<String> getPotentialGroups() {
        return this.potentialGroups;
    }

    public void setPotentialGroups(Set<String> potentialGroups) {
        HashSet<String> oldValues = new HashSet<String>(this.potentialGroups);
        this.potentialGroups = potentialGroups;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAssignmentChange((UserTaskInstance)this, KogitoUserTaskEventSupport.AssignmentType.USER_GROUPS, oldValues, potentialGroups);
        }
        this.updatePersistence();
    }

    public Set<String> getAdminUsers() {
        return this.adminUsers;
    }

    public void setAdminUsers(Set<String> adminUsers) {
        HashSet<String> oldValues = new HashSet<String>(this.adminUsers);
        this.adminUsers = adminUsers;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAssignmentChange((UserTaskInstance)this, KogitoUserTaskEventSupport.AssignmentType.ADMIN_USERS, oldValues, adminUsers);
        }
        this.updatePersistence();
    }

    public Set<String> getAdminGroups() {
        return this.adminGroups;
    }

    public void setAdminGroups(Set<String> adminGroups) {
        HashSet<String> oldValues = new HashSet<String>(this.adminGroups);
        this.adminGroups = adminGroups;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAssignmentChange((UserTaskInstance)this, KogitoUserTaskEventSupport.AssignmentType.ADMIN_GROUPS, oldValues, adminGroups);
        }
        this.updatePersistence();
    }

    public Set<String> getExcludedUsers() {
        return this.excludedUsers;
    }

    public void setExcludedUsers(Set<String> excludedUsers) {
        HashSet<String> oldValues = new HashSet<String>(this.excludedUsers);
        this.excludedUsers = excludedUsers;
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAssignmentChange((UserTaskInstance)this, KogitoUserTaskEventSupport.AssignmentType.USERS_EXCLUDED, oldValues, excludedUsers);
        }
        this.updatePersistence();
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Attachment addAttachment(Attachment attachment) {
        attachment.setId((Serializable)((Object)UUID.randomUUID().toString()));
        attachment.setUpdatedAt(new Date());
        this.attachments.add(attachment);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAttachmentAdded((UserTaskInstance)this, attachment);
        }
        this.updatePersistence();
        return attachment;
    }

    public Attachment updateAttachment(Attachment newAttachment) {
        Optional<Attachment> oldAttachment = this.attachments.stream().filter(e -> ((String)((Object)e.getId())).equals(newAttachment.getId())).findFirst();
        if (oldAttachment.isEmpty()) {
            return null;
        }
        this.attachments.remove(oldAttachment.get());
        if (newAttachment.getName() == null) {
            String path = ((URI)newAttachment.getContent()).getPath();
            int idx = path.lastIndexOf("/");
            if (idx > 0) {
                path = path.substring(idx + 1);
            }
            newAttachment.setName(path);
        }
        newAttachment.setUpdatedAt(new Date());
        this.attachments.add(newAttachment);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAttachmentChange((UserTaskInstance)this, oldAttachment.get(), newAttachment);
        }
        this.updatePersistence();
        return newAttachment;
    }

    public Attachment removeAttachment(Attachment attachment) {
        Optional<Attachment> oldAttachment = this.attachments.stream().filter(e -> ((String)((Object)e.getId())).equals(attachment.getId())).findFirst();
        if (oldAttachment.isEmpty()) {
            return null;
        }
        this.attachments.remove(attachment);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskAttachmentDeleted((UserTaskInstance)this, oldAttachment.get());
        }
        this.updatePersistence();
        return oldAttachment.get();
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public Comment addComment(Comment comment) {
        comment.setId((Serializable)((Object)UUID.randomUUID().toString()));
        comment.setUpdatedAt(new Date());
        this.comments.add(comment);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskCommentAdded((UserTaskInstance)this, comment);
        }
        this.updatePersistence();
        return comment;
    }

    public Comment updateComment(Comment newComment) {
        Optional<Comment> oldComment = this.comments.stream().filter(e -> ((String)((Object)e.getId())).equals(newComment.getId())).findFirst();
        if (oldComment.isEmpty()) {
            return null;
        }
        this.comments.remove(oldComment.get());
        newComment.setUpdatedAt(new Date());
        this.comments.add(newComment);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskCommentChange((UserTaskInstance)this, oldComment.get(), newComment);
        }
        this.updatePersistence();
        return newComment;
    }

    public Comment removeComment(Comment comment) {
        Optional<Comment> oldComment = this.comments.stream().filter(e -> ((String)((Object)e.getId())).equals(comment.getId())).findFirst();
        if (oldComment.isEmpty()) {
            return null;
        }
        this.comments.remove(comment);
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskCommentDeleted((UserTaskInstance)this, oldComment.get());
        }
        this.updatePersistence();
        return oldComment.get();
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void setMetadata(String key, Object value) {
        this.metadata.put(key, value);
        this.updatePersistence();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public Attachment findAttachmentById(String attachmentId) {
        return this.attachments.stream().filter(e -> ((String)((Object)e.getId())).equals(attachmentId)).findAny().orElse(null);
    }

    public Comment findCommentById(String commentId) {
        return this.comments.stream().filter(e -> ((String)((Object)e.getId())).equals(commentId)).findAny().orElse(null);
    }

    public Collection<DeadlineInfo<Notification>> getNotStartedDeadlines() {
        return this.notStartedDeadlines;
    }

    public void setNotStartedDeadlines(Collection<DeadlineInfo<Notification>> notStartedDeadlines) {
        this.notStartedDeadlines = notStartedDeadlines;
    }

    public Collection<DeadlineInfo<Notification>> getNotCompletedDeadlines() {
        return this.notCompletedDeadlines;
    }

    public void setNotCompletedDeadlines(Collection<DeadlineInfo<Notification>> notCompletedDeadlines) {
        this.notCompletedDeadlines = notCompletedDeadlines;
    }

    public Collection<DeadlineInfo<Reassignment>> getNotStartedReassignments() {
        return this.notStartedReassignments;
    }

    public void setNotStartedReassignments(Collection<DeadlineInfo<Reassignment>> notStartedReassignments) {
        this.notStartedReassignments = notStartedReassignments;
    }

    public Collection<DeadlineInfo<Reassignment>> getNotCompletedReassignments() {
        return this.notCompletedReassignments;
    }

    public void setNotCompletedReassignments(Collection<DeadlineInfo<Reassignment>> notCompletedReassignments) {
        this.notCompletedReassignments = notCompletedReassignments;
    }

    public void setJobsService(JobsService jobsService) {
        this.jobsService = jobsService;
    }

    private <T> void initTimers(Map<String, T> timers, Collection<DeadlineInfo<T>> deadlines) {
        for (DeadlineInfo<T> deadline : deadlines) {
            for (JobDescription jobDescription : this.toJobDescription(deadline)) {
                timers.put(jobDescription.id(), deadline.getNotification());
                this.jobsService.scheduleJob(jobDescription);
            }
        }
        this.updatePersistence();
    }

    private <T> void stopTimers(Map<String, T> timers) {
        timers.keySet().stream().filter(Objects::nonNull).forEach(arg_0 -> ((JobsService)this.jobsService).cancelJob(arg_0));
        timers.clear();
        this.updatePersistence();
    }

    private List<JobDescription> toJobDescription(DeadlineInfo<?> deadline) {
        ArrayList<JobDescription> jobs = new ArrayList<JobDescription>();
        for (ScheduleInfo info : deadline.getScheduleInfo()) {
            ExpirationTime expirationTime = DeadlineHelper.getExpirationTime(info);
            jobs.add((JobDescription)UserTaskInstanceJobDescription.newUserTaskInstanceJobDescriptionBuilder().generateId().expirationTime(expirationTime).userTaskInstanceId(this.id).metadata(this.metadata).build());
        }
        return jobs;
    }

    public void startNotStartedDeadlines() {
        this.initTimers(this.notStartedDeadlinesTimers, this.getNotStartedDeadlines());
    }

    public void startNotStartedReassignments() {
        this.initTimers(this.notStartedReassignmentsTimers, this.getNotStartedReassignments());
    }

    public void startNotCompletedDeadlines() {
        this.initTimers(this.notCompletedDeadlinesTimers, this.getNotCompletedDeadlines());
    }

    public void startNotCompletedReassignments() {
        this.initTimers(this.notCompletedReassignmentsTimers, this.getNotCompletedReassignments());
    }

    public void stopNotStartedDeadlines() {
        this.stopTimers(this.notStartedDeadlinesTimers);
    }

    public void stopNotStartedReassignments() {
        this.stopTimers(this.notStartedReassignmentsTimers);
    }

    public void stopNotCompletedDeadlines() {
        this.stopTimers(this.notCompletedDeadlinesTimers);
    }

    public void stopNotCompletedReassignments() {
        this.stopTimers(this.notCompletedReassignmentsTimers);
    }

    public void trigger(UserTaskInstanceJobDescription jobDescription) {
        LOG.trace("trigger timer in user tasks {} and job {}", (Object)this, (Object)jobDescription);
        this.checkAndSendNotification(jobDescription, this.notStartedDeadlinesTimers, this::startNotification);
        this.checkAndSendNotification(jobDescription, this.notCompletedDeadlinesTimers, this::endNotification);
        this.checkAndReassign(jobDescription, this.notStartedReassignmentsTimers);
        this.checkAndReassign(jobDescription, this.notCompletedReassignmentsTimers);
        this.updatePersistence();
    }

    private void checkAndSendNotification(UserTaskInstanceJobDescription timerInstance, Map<String, Notification> timers, Consumer<Notification> publisher) {
        Notification notification = timers.get(timerInstance.id());
        if (notification == null) {
            return;
        }
        if (timerInstance.expirationTime().repeatLimit() <= 0) {
            timers.remove(timerInstance.id());
        }
        publisher.accept(notification);
    }

    private void startNotification(Notification notification) {
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskNotStartedDeadline((UserTaskInstance)this, notification.getData());
        }
    }

    private void endNotification(Notification notification) {
        if (this.userTaskEventSupport != null) {
            this.userTaskEventSupport.fireOnUserTaskNotCompletedDeadline((UserTaskInstance)this, notification.getData());
        }
    }

    private void checkAndReassign(UserTaskInstanceJobDescription timerInstance, Map<String, Reassignment> timers) {
        Reassignment reassignment = timers.remove(timerInstance.id());
        if (reassignment == null) {
            return;
        }
        this.reassign(reassignment);
    }

    private void reassign(Reassignment reassignment) {
        if (!reassignment.getPotentialUsers().isEmpty()) {
            this.setPotentialUsers(reassignment.getPotentialUsers());
        }
        if (!reassignment.getPotentialGroups().isEmpty()) {
            this.setPotentialGroups(reassignment.getPotentialGroups());
        }
        this.transition(this.userTaskLifeCycle.reassignTransition(), Collections.emptyMap(), IdentityProviders.of((String)"WORKFLOW_ENGINE_USER", (String[])new String[0]));
    }

    public String toString() {
        return "DefaultUserTaskInstance [id=" + this.id + ", status=" + this.status + ", actualOwner=" + this.actualOwner + ", taskName=" + this.taskName + ", taskDescription=" + this.taskDescription + ", taskPriority=" + this.taskPriority + ", slaDueDate=" + this.slaDueDate + "]";
    }
}

