/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.UserTaskInstances;
import org.kie.kogito.usertask.impl.DefaultUserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryUserTaskInstances
implements UserTaskInstances {
    private static Logger LOG = LoggerFactory.getLogger(InMemoryUserTaskInstances.class);
    private Map<String, byte[]> userTaskInstances;
    private Function<UserTaskInstance, UserTaskInstance> reconnectUserTaskInstance;
    private Function<UserTaskInstance, UserTaskInstance> disconnectUserTaskInstance;
    private ObjectMapper mapper;

    public InMemoryUserTaskInstances() {
        LOG.info("Initializing InMemoryUsertaskInstances");
        this.userTaskInstances = new HashMap<String, byte[]>();
        this.reconnectUserTaskInstance = null;
        this.disconnectUserTaskInstance = null;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JavaTimeModule());
    }

    public void setReconnectUserTaskInstance(Function<UserTaskInstance, UserTaskInstance> reconnectUserTaskInstance) {
        this.reconnectUserTaskInstance = reconnectUserTaskInstance;
    }

    public void setDisconnectUserTaskInstance(Function<UserTaskInstance, UserTaskInstance> disconnectUserTaskInstance) {
        this.disconnectUserTaskInstance = disconnectUserTaskInstance;
    }

    public Optional<UserTaskInstance> findById(String userTaskInstanceId) {
        try {
            if (!this.userTaskInstances.containsKey(userTaskInstanceId)) {
                return Optional.empty();
            }
            UserTaskInstance userTaskInstance = (UserTaskInstance)this.mapper.readValue(this.userTaskInstances.get(userTaskInstanceId), DefaultUserTaskInstance.class);
            return Optional.ofNullable(this.reconnectUserTaskInstance.apply(userTaskInstance));
        }
        catch (Exception e) {
            LOG.error("during find by Id {}", (Object)userTaskInstanceId, (Object)e);
            return Optional.empty();
        }
    }

    public List<UserTaskInstance> findByIdentity(IdentityProvider identity) {
        try {
            String user = identity.getName();
            Collection roles = identity.getRoles();
            ArrayList<UserTaskInstance> users = new ArrayList<UserTaskInstance>();
            for (String id : this.userTaskInstances.keySet()) {
                UserTaskInstance userTaskInstance = (UserTaskInstance)this.mapper.readValue(this.userTaskInstances.get(id), DefaultUserTaskInstance.class);
                if (!this.checkVisibility(userTaskInstance, user, roles)) continue;
                users.add(this.reconnectUserTaskInstance.apply(userTaskInstance));
            }
            return users;
        }
        catch (Exception e) {
            LOG.error("during find by Identity {}", (Object)identity.getName(), (Object)e);
            return Collections.emptyList();
        }
    }

    private boolean checkVisibility(UserTaskInstance userTaskInstance, String user, Collection<String> roles) {
        Set adminUsers = userTaskInstance.getAdminUsers();
        if (adminUsers.contains(user)) {
            return true;
        }
        HashSet userAdminGroups = new HashSet(userTaskInstance.getAdminGroups());
        userAdminGroups.retainAll(roles);
        if (!userAdminGroups.isEmpty()) {
            return true;
        }
        if (userTaskInstance.getActualOwner() != null && userTaskInstance.getActualOwner().equals(user)) {
            return true;
        }
        HashSet users = new HashSet(userTaskInstance.getPotentialUsers());
        users.removeAll(userTaskInstance.getExcludedUsers());
        if (users.contains(user)) {
            return true;
        }
        HashSet userPotGroups = new HashSet(userTaskInstance.getPotentialGroups());
        userPotGroups.retainAll(roles);
        return !userPotGroups.isEmpty();
    }

    public boolean exists(String userTaskInstanceId) {
        return this.userTaskInstances.containsKey(userTaskInstanceId);
    }

    public UserTaskInstance create(UserTaskInstance userTaskInstance) {
        try {
            LOG.trace("create {}", (Object)userTaskInstance);
            byte[] data = this.mapper.writeValueAsBytes((Object)userTaskInstance);
            this.userTaskInstances.put(userTaskInstance.getId(), data);
            return this.reconnectUserTaskInstance.apply(userTaskInstance);
        }
        catch (Exception e) {
            LOG.error("during create {}", (Object)userTaskInstance.getId(), (Object)e);
            return null;
        }
    }

    public UserTaskInstance update(UserTaskInstance userTaskInstance) {
        try {
            LOG.trace("update {}", (Object)userTaskInstance);
            byte[] data = this.mapper.writeValueAsBytes((Object)userTaskInstance);
            this.userTaskInstances.put(userTaskInstance.getId(), data);
            return userTaskInstance;
        }
        catch (Exception e) {
            LOG.error("during udpate {}", (Object)userTaskInstance.getId(), (Object)e);
            return null;
        }
    }

    public UserTaskInstance remove(UserTaskInstance userTaskInstance) {
        try {
            if (!this.userTaskInstances.containsKey(userTaskInstance.getId())) {
                return null;
            }
            LOG.trace("remove {}", (Object)userTaskInstance);
            this.userTaskInstances.remove(userTaskInstance.getId());
            return this.disconnectUserTaskInstance.apply(userTaskInstance);
        }
        catch (Exception e) {
            LOG.error("during remove {}", (Object)userTaskInstance, (Object)e);
            return null;
        }
    }
}

